/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupMetadata;

public class ListProxyRuleGroupsIterable
implements SdkIterable<ListProxyRuleGroupsResponse> {
    private final NetworkFirewallClient client;
    private final ListProxyRuleGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProxyRuleGroupsIterable(NetworkFirewallClient client, ListProxyRuleGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProxyRuleGroupsResponseFetcher();
    }

    public Iterator<ListProxyRuleGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProxyRuleGroupMetadata> proxyRuleGroups() {
        Function<ListProxyRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxyRuleGroups() != null) {
                return response.proxyRuleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProxyRuleGroupsResponseFetcher
    implements SyncPageFetcher<ListProxyRuleGroupsResponse> {
        private ListProxyRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxyRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProxyRuleGroupsResponse nextPage(ListProxyRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProxyRuleGroupsIterable.this.client.listProxyRuleGroups(ListProxyRuleGroupsIterable.this.firstRequest);
            }
            return ListProxyRuleGroupsIterable.this.client.listProxyRuleGroups((ListProxyRuleGroupsRequest)((Object)ListProxyRuleGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

