/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ListenerPropertiesRequestCopier;
import software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.TlsInterceptPropertiesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateProxyRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(UpdateProxyRequest.getter(UpdateProxyRequest::natGatewayId)).setter(UpdateProxyRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()}).build();
    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyName").getter(UpdateProxyRequest.getter(UpdateProxyRequest::proxyName)).setter(UpdateProxyRequest.setter(Builder::proxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()}).build();
    private static final SdkField<String> PROXY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyArn").getter(UpdateProxyRequest.getter(UpdateProxyRequest::proxyArn)).setter(UpdateProxyRequest.setter(Builder::proxyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyArn").build()}).build();
    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerPropertiesToAdd").getter(UpdateProxyRequest.getter(UpdateProxyRequest::listenerPropertiesToAdd)).setter(UpdateProxyRequest.setter(Builder::listenerPropertiesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerPropertiesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListenerPropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerPropertiesToRemove").getter(UpdateProxyRequest.getter(UpdateProxyRequest::listenerPropertiesToRemove)).setter(UpdateProxyRequest.setter(Builder::listenerPropertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerPropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListenerPropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsInterceptPropertiesRequest> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsInterceptProperties").getter(UpdateProxyRequest.getter(UpdateProxyRequest::tlsInterceptProperties)).setter(UpdateProxyRequest.setter(Builder::tlsInterceptProperties)).constructor(TlsInterceptPropertiesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyRequest.getter(UpdateProxyRequest::updateToken)).setter(UpdateProxyRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD, PROXY_NAME_FIELD, PROXY_ARN_FIELD, LISTENER_PROPERTIES_TO_ADD_FIELD, LISTENER_PROPERTIES_TO_REMOVE_FIELD, TLS_INTERCEPT_PROPERTIES_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyRequest.memberNameToFieldInitializer();
    private final String natGatewayId;
    private final String proxyName;
    private final String proxyArn;
    private final List<ListenerPropertyRequest> listenerPropertiesToAdd;
    private final List<ListenerPropertyRequest> listenerPropertiesToRemove;
    private final TlsInterceptPropertiesRequest tlsInterceptProperties;
    private final String updateToken;

    private UpdateProxyRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.proxyName = builder.proxyName;
        this.proxyArn = builder.proxyArn;
        this.listenerPropertiesToAdd = builder.listenerPropertiesToAdd;
        this.listenerPropertiesToRemove = builder.listenerPropertiesToRemove;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.updateToken = builder.updateToken;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final String proxyName() {
        return this.proxyName;
    }

    public final String proxyArn() {
        return this.proxyArn;
    }

    public final boolean hasListenerPropertiesToAdd() {
        return this.listenerPropertiesToAdd != null && !(this.listenerPropertiesToAdd instanceof SdkAutoConstructList);
    }

    public final List<ListenerPropertyRequest> listenerPropertiesToAdd() {
        return this.listenerPropertiesToAdd;
    }

    public final boolean hasListenerPropertiesToRemove() {
        return this.listenerPropertiesToRemove != null && !(this.listenerPropertiesToRemove instanceof SdkAutoConstructList);
    }

    public final List<ListenerPropertyRequest> listenerPropertiesToRemove() {
        return this.listenerPropertiesToRemove;
    }

    public final TlsInterceptPropertiesRequest tlsInterceptProperties() {
        return this.tlsInterceptProperties;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerPropertiesToAdd() ? this.listenerPropertiesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerPropertiesToRemove() ? this.listenerPropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRequest)) {
            return false;
        }
        UpdateProxyRequest other = (UpdateProxyRequest)((Object)obj);
        return Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.proxyName(), other.proxyName()) && Objects.equals(this.proxyArn(), other.proxyArn()) && this.hasListenerPropertiesToAdd() == other.hasListenerPropertiesToAdd() && Objects.equals(this.listenerPropertiesToAdd(), other.listenerPropertiesToAdd()) && this.hasListenerPropertiesToRemove() == other.hasListenerPropertiesToRemove() && Objects.equals(this.listenerPropertiesToRemove(), other.listenerPropertiesToRemove()) && Objects.equals(this.tlsInterceptProperties(), other.tlsInterceptProperties()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyRequest").add("NatGatewayId", (Object)this.natGatewayId()).add("ProxyName", (Object)this.proxyName()).add("ProxyArn", (Object)this.proxyArn()).add("ListenerPropertiesToAdd", this.hasListenerPropertiesToAdd() ? this.listenerPropertiesToAdd() : null).add("ListenerPropertiesToRemove", this.hasListenerPropertiesToRemove() ? this.listenerPropertiesToRemove() : null).add("TlsInterceptProperties", (Object)this.tlsInterceptProperties()).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "ProxyName": {
                return Optional.ofNullable(clazz.cast(this.proxyName()));
            }
            case "ProxyArn": {
                return Optional.ofNullable(clazz.cast(this.proxyArn()));
            }
            case "ListenerPropertiesToAdd": {
                return Optional.ofNullable(clazz.cast(this.listenerPropertiesToAdd()));
            }
            case "ListenerPropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.listenerPropertiesToRemove()));
            }
            case "TlsInterceptProperties": {
                return Optional.ofNullable(clazz.cast(this.tlsInterceptProperties()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("ProxyArn", PROXY_ARN_FIELD);
        map.put("ListenerPropertiesToAdd", LISTENER_PROPERTIES_TO_ADD_FIELD);
        map.put("ListenerPropertiesToRemove", LISTENER_PROPERTIES_TO_REMOVE_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRequest, T> g) {
        return obj -> g.apply((UpdateProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String natGatewayId;
        private String proxyName;
        private String proxyArn;
        private List<ListenerPropertyRequest> listenerPropertiesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<ListenerPropertyRequest> listenerPropertiesToRemove = DefaultSdkAutoConstructList.getInstance();
        private TlsInterceptPropertiesRequest tlsInterceptProperties;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRequest model) {
            super(model);
            this.natGatewayId(model.natGatewayId);
            this.proxyName(model.proxyName);
            this.proxyArn(model.proxyArn);
            this.listenerPropertiesToAdd(model.listenerPropertiesToAdd);
            this.listenerPropertiesToRemove(model.listenerPropertiesToRemove);
            this.tlsInterceptProperties(model.tlsInterceptProperties);
            this.updateToken(model.updateToken);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyName() {
            return this.proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getProxyArn() {
            return this.proxyArn;
        }

        public final void setProxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
        }

        @Override
        public final Builder proxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerPropertiesToAdd() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier.copyToBuilder(this.listenerPropertiesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerPropertiesToAdd(Collection<ListenerPropertyRequest.BuilderImpl> listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd = ListenerPropertiesRequestCopier.copyFromBuilder(listenerPropertiesToAdd);
        }

        @Override
        public final Builder listenerPropertiesToAdd(Collection<ListenerPropertyRequest> listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd = ListenerPropertiesRequestCopier.copy(listenerPropertiesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToAdd(ListenerPropertyRequest ... listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd(Arrays.asList(listenerPropertiesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToAdd(Consumer<ListenerPropertyRequest.Builder> ... listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd(Stream.of(listenerPropertiesToAdd).map(c -> (ListenerPropertyRequest)((ListenerPropertyRequest.Builder)ListenerPropertyRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerPropertiesToRemove() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier.copyToBuilder(this.listenerPropertiesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerPropertiesToRemove(Collection<ListenerPropertyRequest.BuilderImpl> listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove = ListenerPropertiesRequestCopier.copyFromBuilder(listenerPropertiesToRemove);
        }

        @Override
        public final Builder listenerPropertiesToRemove(Collection<ListenerPropertyRequest> listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove = ListenerPropertiesRequestCopier.copy(listenerPropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToRemove(ListenerPropertyRequest ... listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove(Arrays.asList(listenerPropertiesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToRemove(Consumer<ListenerPropertyRequest.Builder> ... listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove(Stream.of(listenerPropertiesToRemove).map(c -> (ListenerPropertyRequest)((ListenerPropertyRequest.Builder)ListenerPropertyRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptPropertiesRequest.Builder getTlsInterceptProperties() {
            return this.tlsInterceptProperties != null ? this.tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptPropertiesRequest.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyRequest build() {
            return new UpdateProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyRequest> {
        public Builder natGatewayId(String var1);

        public Builder proxyName(String var1);

        public Builder proxyArn(String var1);

        public Builder listenerPropertiesToAdd(Collection<ListenerPropertyRequest> var1);

        public Builder listenerPropertiesToAdd(ListenerPropertyRequest ... var1);

        public Builder listenerPropertiesToAdd(Consumer<ListenerPropertyRequest.Builder> ... var1);

        public Builder listenerPropertiesToRemove(Collection<ListenerPropertyRequest> var1);

        public Builder listenerPropertiesToRemove(ListenerPropertyRequest ... var1);

        public Builder listenerPropertiesToRemove(Consumer<ListenerPropertyRequest.Builder> ... var1);

        public Builder tlsInterceptProperties(TlsInterceptPropertiesRequest var1);

        default public Builder tlsInterceptProperties(Consumer<TlsInterceptPropertiesRequest.Builder> tlsInterceptProperties) {
            return this.tlsInterceptProperties((TlsInterceptPropertiesRequest)((TlsInterceptPropertiesRequest.Builder)TlsInterceptPropertiesRequest.builder().applyMutation(tlsInterceptProperties)).build());
        }

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

