/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProxyState {
    ATTACHING("ATTACHING"),
    ATTACHED("ATTACHED"),
    DETACHING("DETACHING"),
    DETACHED("DETACHED"),
    ATTACH_FAILED("ATTACH_FAILED"),
    DETACH_FAILED("DETACH_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProxyState> VALUE_MAP;
    private final String value;

    private ProxyState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProxyState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProxyState> knownValues() {
        EnumSet<ProxyState> knownValues = EnumSet.allOf(ProxyState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProxyState.class, ProxyState::toString);
    }
}

