/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConditionValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxyRuleCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxyRuleCondition> {
    private static final SdkField<String> CONDITION_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionOperator").getter(ProxyRuleCondition.getter(ProxyRuleCondition::conditionOperator)).setter(ProxyRuleCondition.setter(Builder::conditionOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOperator").build()}).build();
    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionKey").getter(ProxyRuleCondition.getter(ProxyRuleCondition::conditionKey)).setter(ProxyRuleCondition.setter(Builder::conditionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionKey").build()}).build();
    private static final SdkField<List<String>> CONDITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConditionValues").getter(ProxyRuleCondition.getter(ProxyRuleCondition::conditionValues)).setter(ProxyRuleCondition.setter(Builder::conditionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_OPERATOR_FIELD, CONDITION_KEY_FIELD, CONDITION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProxyRuleCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conditionOperator;
    private final String conditionKey;
    private final List<String> conditionValues;

    private ProxyRuleCondition(BuilderImpl builder) {
        this.conditionOperator = builder.conditionOperator;
        this.conditionKey = builder.conditionKey;
        this.conditionValues = builder.conditionValues;
    }

    public final String conditionOperator() {
        return this.conditionOperator;
    }

    public final String conditionKey() {
        return this.conditionKey;
    }

    public final boolean hasConditionValues() {
        return this.conditionValues != null && !(this.conditionValues instanceof SdkAutoConstructList);
    }

    public final List<String> conditionValues() {
        return this.conditionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionOperator());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionValues() ? this.conditionValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyRuleCondition)) {
            return false;
        }
        ProxyRuleCondition other = (ProxyRuleCondition)obj;
        return Objects.equals(this.conditionOperator(), other.conditionOperator()) && Objects.equals(this.conditionKey(), other.conditionKey()) && this.hasConditionValues() == other.hasConditionValues() && Objects.equals(this.conditionValues(), other.conditionValues());
    }

    public final String toString() {
        return ToString.builder((String)"ProxyRuleCondition").add("ConditionOperator", (Object)this.conditionOperator()).add("ConditionKey", (Object)this.conditionKey()).add("ConditionValues", this.hasConditionValues() ? this.conditionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionOperator": {
                return Optional.ofNullable(clazz.cast(this.conditionOperator()));
            }
            case "ConditionKey": {
                return Optional.ofNullable(clazz.cast(this.conditionKey()));
            }
            case "ConditionValues": {
                return Optional.ofNullable(clazz.cast(this.conditionValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConditionOperator", CONDITION_OPERATOR_FIELD);
        map.put("ConditionKey", CONDITION_KEY_FIELD);
        map.put("ConditionValues", CONDITION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyRuleCondition, T> g) {
        return obj -> g.apply((ProxyRuleCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conditionOperator;
        private String conditionKey;
        private List<String> conditionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyRuleCondition model) {
            this.conditionOperator(model.conditionOperator);
            this.conditionKey(model.conditionKey);
            this.conditionValues(model.conditionValues);
        }

        public final String getConditionOperator() {
            return this.conditionOperator;
        }

        public final void setConditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
        }

        @Override
        public final Builder conditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
            return this;
        }

        public final String getConditionKey() {
            return this.conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final Collection<String> getConditionValues() {
            if (this.conditionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conditionValues;
        }

        public final void setConditionValues(Collection<String> conditionValues) {
            this.conditionValues = ProxyConditionValueListCopier.copy(conditionValues);
        }

        @Override
        public final Builder conditionValues(Collection<String> conditionValues) {
            this.conditionValues = ProxyConditionValueListCopier.copy(conditionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionValues(String ... conditionValues) {
            this.conditionValues(Arrays.asList(conditionValues));
            return this;
        }

        public ProxyRuleCondition build() {
            return new ProxyRuleCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxyRuleCondition> {
        public Builder conditionOperator(String var1);

        public Builder conditionKey(String var1);

        public Builder conditionValues(Collection<String> var1);

        public Builder conditionValues(String ... var1);
    }
}

