/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRulesByRequestPhase;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxyRuleGroupRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateProxyRuleGroupRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupName").getter(CreateProxyRuleGroupRequest.getter(CreateProxyRuleGroupRequest::proxyRuleGroupName)).setter(CreateProxyRuleGroupRequest.setter(Builder::proxyRuleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateProxyRuleGroupRequest.getter(CreateProxyRuleGroupRequest::description)).setter(CreateProxyRuleGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ProxyRulesByRequestPhase> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rules").getter(CreateProxyRuleGroupRequest.getter(CreateProxyRuleGroupRequest::rules)).setter(CreateProxyRuleGroupRequest.setter(Builder::rules)).constructor(ProxyRulesByRequestPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProxyRuleGroupRequest.getter(CreateProxyRuleGroupRequest::tags)).setter(CreateProxyRuleGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD, DESCRIPTION_FIELD, RULES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProxyRuleGroupRequest.memberNameToFieldInitializer();
    private final String proxyRuleGroupName;
    private final String description;
    private final ProxyRulesByRequestPhase rules;
    private final List<Tag> tags;

    private CreateProxyRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.description = builder.description;
        this.rules = builder.rules;
        this.tags = builder.tags;
    }

    public final String proxyRuleGroupName() {
        return this.proxyRuleGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final ProxyRulesByRequestPhase rules() {
        return this.rules;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRuleGroupRequest)) {
            return false;
        }
        CreateProxyRuleGroupRequest other = (CreateProxyRuleGroupRequest)((Object)obj);
        return Objects.equals(this.proxyRuleGroupName(), other.proxyRuleGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rules(), other.rules()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxyRuleGroupRequest").add("ProxyRuleGroupName", (Object)this.proxyRuleGroupName()).add("Description", (Object)this.description()).add("Rules", (Object)this.rules()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRuleGroupRequest, T> g) {
        return obj -> g.apply((CreateProxyRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyRuleGroupName;
        private String description;
        private ProxyRulesByRequestPhase rules;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRuleGroupRequest model) {
            super(model);
            this.proxyRuleGroupName(model.proxyRuleGroupName);
            this.description(model.description);
            this.rules(model.rules);
            this.tags(model.tags);
        }

        public final String getProxyRuleGroupName() {
            return this.proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProxyRulesByRequestPhase.Builder getRules() {
            return this.rules != null ? this.rules.toBuilder() : null;
        }

        public final void setRules(ProxyRulesByRequestPhase.BuilderImpl rules) {
            this.rules = rules != null ? rules.build() : null;
        }

        @Override
        public final Builder rules(ProxyRulesByRequestPhase rules) {
            this.rules = rules;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyRuleGroupRequest build() {
            return new CreateProxyRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProxyRuleGroupRequest> {
        public Builder proxyRuleGroupName(String var1);

        public Builder description(String var1);

        public Builder rules(ProxyRulesByRequestPhase var1);

        default public Builder rules(Consumer<ProxyRulesByRequestPhase.Builder> rules) {
            return this.rules((ProxyRulesByRequestPhase)((ProxyRulesByRequestPhase.Builder)ProxyRulesByRequestPhase.builder().applyMutation(rules)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

