/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRuleGroupRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DescribeRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(DescribeRuleGroupRequest.getter(DescribeRuleGroupRequest::ruleGroupName)).setter(DescribeRuleGroupRequest.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(DescribeRuleGroupRequest.getter(DescribeRuleGroupRequest::ruleGroupArn)).setter(DescribeRuleGroupRequest.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeRuleGroupRequest.getter(DescribeRuleGroupRequest::typeAsString)).setter(DescribeRuleGroupRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Boolean> ANALYZE_RULE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AnalyzeRuleGroup").getter(DescribeRuleGroupRequest.getter(DescribeRuleGroupRequest::analyzeRuleGroup)).setter(DescribeRuleGroupRequest.setter(Builder::analyzeRuleGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeRuleGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_NAME_FIELD, RULE_GROUP_ARN_FIELD, TYPE_FIELD, ANALYZE_RULE_GROUP_FIELD));
    private final String ruleGroupName;
    private final String ruleGroupArn;
    private final String type;
    private final Boolean analyzeRuleGroup;

    private DescribeRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroupArn = builder.ruleGroupArn;
        this.type = builder.type;
        this.analyzeRuleGroup = builder.analyzeRuleGroup;
    }

    public final String ruleGroupName() {
        return this.ruleGroupName;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Boolean analyzeRuleGroup() {
        return this.analyzeRuleGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzeRuleGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleGroupRequest)) {
            return false;
        }
        DescribeRuleGroupRequest other = (DescribeRuleGroupRequest)((Object)obj);
        return Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.analyzeRuleGroup(), other.analyzeRuleGroup());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRuleGroupRequest").add("RuleGroupName", (Object)this.ruleGroupName()).add("RuleGroupArn", (Object)this.ruleGroupArn()).add("Type", (Object)this.typeAsString()).add("AnalyzeRuleGroup", (Object)this.analyzeRuleGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AnalyzeRuleGroup": {
                return Optional.ofNullable(clazz.cast(this.analyzeRuleGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleGroupRequest, T> g) {
        return obj -> g.apply((DescribeRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String ruleGroupName;
        private String ruleGroupArn;
        private String type;
        private Boolean analyzeRuleGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleGroupRequest model) {
            super(model);
            this.ruleGroupName(model.ruleGroupName);
            this.ruleGroupArn(model.ruleGroupArn);
            this.type(model.type);
            this.analyzeRuleGroup(model.analyzeRuleGroup);
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getAnalyzeRuleGroup() {
            return this.analyzeRuleGroup;
        }

        public final void setAnalyzeRuleGroup(Boolean analyzeRuleGroup) {
            this.analyzeRuleGroup = analyzeRuleGroup;
        }

        @Override
        public final Builder analyzeRuleGroup(Boolean analyzeRuleGroup) {
            this.analyzeRuleGroup = analyzeRuleGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRuleGroupRequest build() {
            return new DescribeRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRuleGroupRequest> {
        public Builder ruleGroupName(String var1);

        public Builder ruleGroupArn(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder analyzeRuleGroup(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

