/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.GeneratedRulesType;
import software.amazon.awssdk.services.networkfirewall.model.RuleTargetsCopier;
import software.amazon.awssdk.services.networkfirewall.model.TargetType;
import software.amazon.awssdk.services.networkfirewall.model.TargetTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RulesSourceList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RulesSourceList> {
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(RulesSourceList.getter(RulesSourceList::targets)).setter(RulesSourceList.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetTypes").getter(RulesSourceList.getter(RulesSourceList::targetTypesAsStrings)).setter(RulesSourceList.setter(Builder::targetTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GENERATED_RULES_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedRulesType").getter(RulesSourceList.getter(RulesSourceList::generatedRulesTypeAsString)).setter(RulesSourceList.setter(Builder::generatedRulesType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedRulesType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD, TARGET_TYPES_FIELD, GENERATED_RULES_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> targets;
    private final List<String> targetTypes;
    private final String generatedRulesType;

    private RulesSourceList(BuilderImpl builder) {
        this.targets = builder.targets;
        this.targetTypes = builder.targetTypes;
        this.generatedRulesType = builder.generatedRulesType;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final List<TargetType> targetTypes() {
        return TargetTypesCopier.copyStringToEnum(this.targetTypes);
    }

    public final boolean hasTargetTypes() {
        return this.targetTypes != null && !(this.targetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> targetTypesAsStrings() {
        return this.targetTypes;
    }

    public final GeneratedRulesType generatedRulesType() {
        return GeneratedRulesType.fromValue(this.generatedRulesType);
    }

    public final String generatedRulesTypeAsString() {
        return this.generatedRulesType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTypes() ? this.targetTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedRulesTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesSourceList)) {
            return false;
        }
        RulesSourceList other = (RulesSourceList)obj;
        return this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTargetTypes() == other.hasTargetTypes() && Objects.equals(this.targetTypesAsStrings(), other.targetTypesAsStrings()) && Objects.equals(this.generatedRulesTypeAsString(), other.generatedRulesTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RulesSourceList").add("Targets", this.hasTargets() ? this.targets() : null).add("TargetTypes", this.hasTargetTypes() ? this.targetTypesAsStrings() : null).add("GeneratedRulesType", (Object)this.generatedRulesTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetTypes": {
                return Optional.ofNullable(clazz.cast(this.targetTypesAsStrings()));
            }
            case "GeneratedRulesType": {
                return Optional.ofNullable(clazz.cast(this.generatedRulesTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RulesSourceList, T> g) {
        return obj -> g.apply((RulesSourceList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetTypes = DefaultSdkAutoConstructList.getInstance();
        private String generatedRulesType;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesSourceList model) {
            this.targets(model.targets);
            this.targetTypesWithStrings(model.targetTypes);
            this.generatedRulesType(model.generatedRulesType);
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = RuleTargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = RuleTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getTargetTypes() {
            if (this.targetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetTypes;
        }

        public final void setTargetTypes(Collection<String> targetTypes) {
            this.targetTypes = TargetTypesCopier.copy(targetTypes);
        }

        @Override
        public final Builder targetTypesWithStrings(Collection<String> targetTypes) {
            this.targetTypes = TargetTypesCopier.copy(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypesWithStrings(String ... targetTypes) {
            this.targetTypesWithStrings(Arrays.asList(targetTypes));
            return this;
        }

        @Override
        public final Builder targetTypes(Collection<TargetType> targetTypes) {
            this.targetTypes = TargetTypesCopier.copyEnumToString(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypes(TargetType ... targetTypes) {
            this.targetTypes(Arrays.asList(targetTypes));
            return this;
        }

        public final String getGeneratedRulesType() {
            return this.generatedRulesType;
        }

        public final void setGeneratedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
        }

        @Override
        public final Builder generatedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
            return this;
        }

        @Override
        public final Builder generatedRulesType(GeneratedRulesType generatedRulesType) {
            this.generatedRulesType(generatedRulesType == null ? null : generatedRulesType.toString());
            return this;
        }

        public RulesSourceList build() {
            return new RulesSourceList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RulesSourceList> {
        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder targetTypesWithStrings(Collection<String> var1);

        public Builder targetTypesWithStrings(String ... var1);

        public Builder targetTypes(Collection<TargetType> var1);

        public Builder targetTypes(TargetType ... var1);

        public Builder generatedRulesType(String var1);

        public Builder generatedRulesType(GeneratedRulesType var1);
    }
}

