/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stateful inspection criteria for a domain list rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RulesSourceList implements SdkPojo, Serializable, ToCopyableBuilder<RulesSourceList.Builder, RulesSourceList> {
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(RulesSourceList::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetTypes")
            .getter(getter(RulesSourceList::targetTypesAsStrings))
            .setter(setter(Builder::targetTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GENERATED_RULES_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedRulesType").getter(getter(RulesSourceList::generatedRulesTypeAsString))
            .setter(setter(Builder::generatedRulesType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedRulesType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD,
            TARGET_TYPES_FIELD, GENERATED_RULES_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> targets;

    private final List<String> targetTypes;

    private final String generatedRulesType;

    private RulesSourceList(BuilderImpl builder) {
        this.targets = builder.targets;
        this.targetTypes = builder.targetTypes;
        this.generatedRulesType = builder.generatedRulesType;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate them with
     * commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate
     *         them with commas.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<TargetType> targetTypes() {
        return TargetTypesCopier.copyStringToEnum(targetTypes);
    }

    /**
     * Returns true if the TargetTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargetTypes() {
        return targetTypes != null && !(targetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<String> targetTypesAsStrings() {
        return targetTypes;
    }

    /**
     * <p>
     * Whether you want to allow or deny access to the domains in your target list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #generatedRulesType} will return {@link GeneratedRulesType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #generatedRulesTypeAsString}.
     * </p>
     * 
     * @return Whether you want to allow or deny access to the domains in your target list.
     * @see GeneratedRulesType
     */
    public final GeneratedRulesType generatedRulesType() {
        return GeneratedRulesType.fromValue(generatedRulesType);
    }

    /**
     * <p>
     * Whether you want to allow or deny access to the domains in your target list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #generatedRulesType} will return {@link GeneratedRulesType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #generatedRulesTypeAsString}.
     * </p>
     * 
     * @return Whether you want to allow or deny access to the domains in your target list.
     * @see GeneratedRulesType
     */
    public final String generatedRulesTypeAsString() {
        return generatedRulesType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetTypes() ? targetTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(generatedRulesTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesSourceList)) {
            return false;
        }
        RulesSourceList other = (RulesSourceList) obj;
        return hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasTargetTypes() == other.hasTargetTypes()
                && Objects.equals(targetTypesAsStrings(), other.targetTypesAsStrings())
                && Objects.equals(generatedRulesTypeAsString(), other.generatedRulesTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RulesSourceList").add("Targets", hasTargets() ? targets() : null)
                .add("TargetTypes", hasTargetTypes() ? targetTypesAsStrings() : null)
                .add("GeneratedRulesType", generatedRulesTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TargetTypes":
            return Optional.ofNullable(clazz.cast(targetTypesAsStrings()));
        case "GeneratedRulesType":
            return Optional.ofNullable(clazz.cast(generatedRulesTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RulesSourceList, T> g) {
        return obj -> g.apply((RulesSourceList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RulesSourceList> {
        /**
         * <p>
         * The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate them
         * with commas.
         * </p>
         * 
         * @param targets
         *        The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate
         *        them with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate them
         * with commas.
         * </p>
         * 
         * @param targets
         *        The domains that you want to inspect for in your traffic flows. To provide multiple domains, separate
         *        them with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p/>
         * 
         * @param targetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypesWithStrings(Collection<String> targetTypes);

        /**
         * <p/>
         * 
         * @param targetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypesWithStrings(String... targetTypes);

        /**
         * <p/>
         * 
         * @param targetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypes(Collection<TargetType> targetTypes);

        /**
         * <p/>
         * 
         * @param targetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypes(TargetType... targetTypes);

        /**
         * <p>
         * Whether you want to allow or deny access to the domains in your target list.
         * </p>
         * 
         * @param generatedRulesType
         *        Whether you want to allow or deny access to the domains in your target list.
         * @see GeneratedRulesType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedRulesType
         */
        Builder generatedRulesType(String generatedRulesType);

        /**
         * <p>
         * Whether you want to allow or deny access to the domains in your target list.
         * </p>
         * 
         * @param generatedRulesType
         *        Whether you want to allow or deny access to the domains in your target list.
         * @see GeneratedRulesType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedRulesType
         */
        Builder generatedRulesType(GeneratedRulesType generatedRulesType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetTypes = DefaultSdkAutoConstructList.getInstance();

        private String generatedRulesType;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesSourceList model) {
            targets(model.targets);
            targetTypesWithStrings(model.targetTypes);
            generatedRulesType(model.generatedRulesType);
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = RuleTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = RuleTargetsCopier.copy(targets);
        }

        public final Collection<String> getTargetTypes() {
            if (targetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return targetTypes;
        }

        @Override
        public final Builder targetTypesWithStrings(Collection<String> targetTypes) {
            this.targetTypes = TargetTypesCopier.copy(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypesWithStrings(String... targetTypes) {
            targetTypesWithStrings(Arrays.asList(targetTypes));
            return this;
        }

        @Override
        public final Builder targetTypes(Collection<TargetType> targetTypes) {
            this.targetTypes = TargetTypesCopier.copyEnumToString(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypes(TargetType... targetTypes) {
            targetTypes(Arrays.asList(targetTypes));
            return this;
        }

        public final void setTargetTypes(Collection<String> targetTypes) {
            this.targetTypes = TargetTypesCopier.copy(targetTypes);
        }

        public final String getGeneratedRulesType() {
            return generatedRulesType;
        }

        @Override
        public final Builder generatedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
            return this;
        }

        @Override
        public final Builder generatedRulesType(GeneratedRulesType generatedRulesType) {
            this.generatedRulesType(generatedRulesType == null ? null : generatedRulesType.toString());
            return this;
        }

        public final void setGeneratedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
        }

        @Override
        public RulesSourceList build() {
            return new RulesSourceList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
