/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class NettyConfiguration {
    private final AttributeMap configuration;

    public NettyConfiguration(AttributeMap configuration) {
        this.configuration = configuration;
    }

    public <T> T attribute(AttributeMap.Key<T> key) {
        return (T)this.configuration.get(key);
    }

    public int connectTimeoutMillis() {
        return NumericUtils.saturatedCast((long)((Duration)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis());
    }

    public int connectionAcquireTimeoutMillis() {
        return NumericUtils.saturatedCast((long)((Duration)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).toMillis());
    }

    public int maxConnections() {
        return (Integer)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
    }

    public int maxPendingConnectionAcquires() {
        return (Integer)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES);
    }

    public boolean trustAllCertificates() {
        return (Boolean)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES);
    }

    public int readTimeoutMillis() {
        return NumericUtils.saturatedCast((long)((Duration)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis());
    }

    public int writeTimeoutMillis() {
        return NumericUtils.saturatedCast((long)((Duration)this.configuration.get((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT)).toMillis());
    }
}

