/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.LastHttpContentHandler;
import software.amazon.awssdk.http.nio.netty.internal.ResponseHandler;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.http2.FlushOnReadHandler;
import software.amazon.awssdk.http.nio.netty.internal.nrs.HttpStreamsClientHandler;
import software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public class HandlerRemovingChannelPool
implements SdkChannelPool {
    private final SdkChannelPool delegate;

    public HandlerRemovingChannelPool(SdkChannelPool delegate) {
        this.delegate = delegate;
    }

    public Future<Channel> acquire() {
        return this.delegate.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegate.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)new DefaultPromise((EventExecutor)channel.eventLoop()));
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        this.removePerRequestHandlers(channel).addListener(future -> this.delegate.release(channel, promise));
        return promise;
    }

    public void close() {
        this.delegate.close();
    }

    private Future<?> removePerRequestHandlers(Channel channel) {
        return NettyUtils.doInEventLoop((EventExecutor)channel.eventLoop(), () -> {
            channel.attr(ChannelAttributeKey.IN_USE).set((Object)false);
            if (channel.isOpen() || channel.isRegistered()) {
                ChannelUtils.removeIfExists(channel.pipeline(), HttpStreamsClientHandler.class, LastHttpContentHandler.class, FlushOnReadHandler.class, ResponseHandler.class, ReadTimeoutHandler.class, WriteTimeoutHandler.class);
            }
        });
    }

    @Override
    public CompletableFuture<Void> collectChannelPoolMetrics(MetricCollector metrics) {
        return this.delegate.collectChannelPoolMetrics(metrics);
    }
}

