/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.http2.GoAwayException;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public class MultiplexedChannelRecord {
    private final Future<Channel> connectionFuture;
    private final Map<ChannelId, Http2StreamChannel> childChannels;
    private final AtomicLong availableStreams;
    private final BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser;
    private volatile Channel connection;
    private volatile boolean goAway = false;

    MultiplexedChannelRecord(Future<Channel> connectionFuture, long maxConcurrencyPerConnection, BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser) {
        this.connectionFuture = connectionFuture;
        this.availableStreams = new AtomicLong(maxConcurrencyPerConnection);
        this.childChannels = new ConcurrentHashMap<ChannelId, Http2StreamChannel>(NumericUtils.saturatedCast((long)maxConcurrencyPerConnection));
        this.channelReleaser = channelReleaser;
    }

    @SdkTestInternalApi
    MultiplexedChannelRecord(Future<Channel> connectionFuture, Channel connection, long maxConcurrencyPerConnection, BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser) {
        this.connectionFuture = connectionFuture;
        this.childChannels = new ConcurrentHashMap<ChannelId, Http2StreamChannel>(NumericUtils.saturatedCast((long)maxConcurrencyPerConnection));
        this.availableStreams = new AtomicLong(maxConcurrencyPerConnection);
        this.channelReleaser = channelReleaser;
        this.connection = connection;
    }

    MultiplexedChannelRecord acquire(Promise<Channel> channelPromise) {
        this.availableStreams.decrementAndGet();
        if (this.connection != null) {
            this.createChildChannel(channelPromise);
        } else {
            this.connectionFuture.addListener(future -> {
                if (future.isSuccess()) {
                    this.connection = (Channel)future.getNow();
                    this.connection.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).set((Object)this);
                    this.createChildChannel(channelPromise);
                } else {
                    channelPromise.setFailure(future.cause());
                    this.channelReleaser.accept(this.connection, this);
                }
            });
        }
        return this;
    }

    void goAway(Http2GoAwayFrame frame) {
        this.goAway = true;
        GoAwayException exception = new GoAwayException(frame.errorCode(), frame.content());
        this.childChannels.entrySet().stream().map(Map.Entry::getValue).filter(cc -> cc.stream().id() > frame.lastStreamId()).forEach(cc -> cc.eventLoop().execute(() -> this.shutdownChildChannel((Channel)cc, exception)));
    }

    void shutdownChildChannels(Throwable t) {
        this.goAway = true;
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> {
            for (Channel channel : this.childChannels.values()) {
                this.shutdownChildChannel(channel, t);
            }
        });
    }

    private void shutdownChildChannel(Channel childChannel, Throwable t) {
        childChannel.pipeline().fireExceptionCaught(t);
    }

    private void createChildChannel(Promise<Channel> channelPromise) {
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> this.createChildChannel0(channelPromise), channelPromise);
    }

    private void createChildChannel0(Promise<Channel> channelPromise) {
        if (this.goAway) {
            channelPromise.tryFailure((Throwable)new IOException("No streams are available on this connection."));
        } else {
            ((CompletableFuture)this.connection.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).whenComplete(NettyUtils.asyncPromiseNotifyingBiConsumer(this.bootstrapChildChannel(), channelPromise));
        }
    }

    private BiConsumer<Protocol, Promise<Channel>> bootstrapChildChannel() {
        return (s, p) -> new Http2StreamChannelBootstrap(this.connection).open().addListener(future -> {
            if (future.isSuccess()) {
                Http2StreamChannel channel = (Http2StreamChannel)future.getNow();
                this.childChannels.put(channel.id(), channel);
            } else {
                if (!this.connection.isActive()) {
                    this.channelReleaser.accept(this.connection, this);
                }
                this.availableStreams.incrementAndGet();
            }
        }).addListener(NettyUtils.promiseNotifyingListener(p));
    }

    void release(Channel channel) {
        this.availableStreams.incrementAndGet();
        this.childChannels.remove(channel.id());
    }

    boolean reusable() {
        return !this.isPingInflight() && this.availableStreams.get() > 0L && !this.goAway;
    }

    Future<Channel> getConnectionFuture() {
        return this.connectionFuture;
    }

    private boolean isPingInflight() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.attr(ChannelAttributeKey.PING_TRACKER).get() != null;
    }
}

