/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.http.HttpStreamsClientHandler;
import com.typesafe.netty.http.StreamedHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKeys;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.ResponseHandler;
import software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

public final class RunnableRequest
implements AbortableRunnable {
    private static final Logger log = LoggerFactory.getLogger(RunnableRequest.class);
    private final RequestContext context;
    private volatile Channel channel;

    public RunnableRequest(RequestContext context) {
        this.context = context;
    }

    public void run() {
        this.context.channelPool().acquire().addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                try {
                    this.channel = (Channel)channelFuture.getNow();
                    this.initializePerRequestHandlers();
                    this.channel.attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).set((Object)this.context);
                    this.channel.attr(ChannelAttributeKeys.RESPONSE_COMPLETE_KEY).set((Object)false);
                    this.makeRequest(this.context.nettyRequest());
                }
                catch (Exception e) {
                    this.handleFailure(() -> "Failed to make request to " + this.endpoint(), e);
                }
            } else {
                this.handleFailure(() -> "Failed to create connection to " + this.endpoint(), channelFuture.cause());
            }
        });
    }

    private void initializePerRequestHandlers() {
        this.channel.pipeline().addLast(new ChannelHandler[]{new HttpStreamsClientHandler()});
        this.channel.pipeline().addLast(new ChannelHandler[]{new ResponseHandler()});
    }

    public void abort() {
        if (this.channel != null) {
            RunnableRequest.closeAndRelease(this.channel);
        }
    }

    private void makeRequest(HttpRequest request) {
        log.debug("Writing request: {}", (Object)request);
        this.channel.pipeline().addFirst(new ChannelHandler[]{new WriteTimeoutHandler(this.context.configuration().writeTimeout())});
        this.channel.writeAndFlush((Object)new StreamedRequest(request, (Publisher<ByteBuffer>)this.context.sdkRequestProvider(), this.channel)).addListener(wireCall -> {
            ChannelUtils.removeIfExists(this.channel.pipeline(), WriteTimeoutHandler.class);
            if (wireCall.isSuccess()) {
                this.channel.pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(this.context.configuration().readTimeout())});
                this.channel.read();
            } else {
                this.handleFailure(() -> "Failed to make request to " + this.endpoint(), wireCall.cause());
            }
        });
    }

    private URI endpoint() {
        return this.context.sdkRequest().getUri();
    }

    private void handleFailure(Supplier<String> msg, Throwable cause) {
        log.error(msg.get(), cause);
        RunnableRequest.runAndLogError("Exception thrown from AsyncResponseHandler", () -> this.context.handler().exceptionOccurred(cause));
        if (this.channel != null) {
            RunnableRequest.runAndLogError("Unable to release channel back to the pool.", () -> RunnableRequest.closeAndRelease(this.channel));
        }
    }

    private static void closeAndRelease(Channel channel) {
        RequestContext requestCtx = (RequestContext)channel.attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).get();
        channel.close().addListener(ignored -> requestCtx.channelPool().release(channel));
    }

    private static void runAndLogError(String errorMsg, FunctionalUtils.UnsafeRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.error(errorMsg, (Throwable)e);
        }
    }

    private static class StreamedRequest
    extends DelegateHttpRequest
    implements StreamedHttpRequest {
        private final Publisher<ByteBuffer> publisher;
        private final Channel channel;

        StreamedRequest(HttpRequest request, Publisher<ByteBuffer> publisher, Channel channel) {
            super(request);
            this.publisher = publisher;
            this.channel = channel;
        }

        public void subscribe(final Subscriber<? super HttpContent> subscriber) {
            this.publisher.subscribe((Subscriber)new Subscriber<ByteBuffer>(){

                public void onSubscribe(Subscription subscription) {
                    subscriber.onSubscribe(subscription);
                }

                public void onNext(ByteBuffer byteBuffer) {
                    ByteBuf buffer = channel.alloc().buffer(byteBuffer.remaining());
                    buffer.writeBytes(byteBuffer);
                    DefaultHttpContent content = new DefaultHttpContent(buffer);
                    subscriber.onNext((Object)content);
                }

                public void onError(Throwable t) {
                    subscriber.onError(t);
                }

                public void onComplete() {
                    subscriber.onComplete();
                }
            });
        }
    }

    static class DelegateHttpRequest
    implements HttpRequest {
        protected final HttpRequest request;

        DelegateHttpRequest(HttpRequest request) {
            this.request = request;
        }

        public HttpRequest setMethod(HttpMethod method) {
            this.request.setMethod(method);
            return this;
        }

        public HttpRequest setUri(String uri) {
            this.request.setUri(uri);
            return this;
        }

        public HttpMethod getMethod() {
            return this.request.getMethod();
        }

        public HttpMethod method() {
            return this.request.method();
        }

        public String getUri() {
            return this.request.getUri();
        }

        public String uri() {
            return this.request.uri();
        }

        public HttpVersion getProtocolVersion() {
            return this.request.getProtocolVersion();
        }

        public HttpVersion protocolVersion() {
            return this.request.protocolVersion();
        }

        public HttpRequest setProtocolVersion(HttpVersion version) {
            this.request.setProtocolVersion(version);
            return this;
        }

        public HttpHeaders headers() {
            return this.request.headers();
        }

        public DecoderResult getDecoderResult() {
            return this.request.getDecoderResult();
        }

        public DecoderResult decoderResult() {
            return this.request.decoderResult();
        }

        public void setDecoderResult(DecoderResult result) {
            this.request.setDecoderResult(result);
        }

        public String toString() {
            return this.getClass().getName() + "(" + this.request.toString() + ")";
        }
    }
}

