/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.channel.EventLoopGroup;
import java.util.Optional;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.EventLoopGroupFactory;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@ReviewBeforeRelease(value="Do we want this approach to force mutual exclusion or should we flatten it out and do mutex checks at runtime?")
public final class EventLoopGroupConfiguration
implements ToCopyableBuilder<Builder, EventLoopGroupConfiguration> {
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroupFactory eventLoopGroupFactory;

    private EventLoopGroupConfiguration(DefaultBuilder builder) {
        this.eventLoopGroup = builder.eventLoopGroup;
        this.eventLoopGroupFactory = builder.eventLoopGroupFactory;
    }

    public Optional<EventLoopGroup> eventLoopGroup() {
        return Optional.ofNullable(this.eventLoopGroup);
    }

    public Optional<EventLoopGroupFactory> eventLoopGroupFactory() {
        return Optional.ofNullable(this.eventLoopGroupFactory);
    }

    public Builder toBuilder() {
        return new DefaultBuilder().eventLoopGroup(this.eventLoopGroup).eventLoopGroupFactory(this.eventLoopGroupFactory);
    }

    @SdkInternalApi
    Optional<Either<EventLoopGroup, EventLoopGroupFactory>> toEither() {
        return Either.fromNullable((Object)this.eventLoopGroup, (Object)this.eventLoopGroupFactory);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public String toString() {
        return ToString.builder((String)"EventLoopGroupConfiguration").add("eventLoopGroup", (Object)this.eventLoopGroup).add("eventLoopGroupFactory", (Object)this.eventLoopGroupFactory).build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private EventLoopGroup eventLoopGroup;
        private EventLoopGroupFactory eventLoopGroupFactory;

        private DefaultBuilder() {
        }

        public DefaultBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup(eventLoopGroup);
        }

        public DefaultBuilder eventLoopGroupFactory(EventLoopGroupFactory eventLoopGroupFactory) {
            this.eventLoopGroupFactory = eventLoopGroupFactory;
            return this;
        }

        public void setEventLoopGroupFactory(EventLoopGroupFactory eventLoopGroupFactory) {
            this.eventLoopGroupFactory(eventLoopGroupFactory);
        }

        public EventLoopGroupConfiguration build() {
            return new EventLoopGroupConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventLoopGroupConfiguration> {
        public SdkBuilder<?, EventLoopGroupConfiguration> eventLoopGroup(EventLoopGroup var1);

        public SdkBuilder<?, EventLoopGroupConfiguration> eventLoopGroupFactory(EventLoopGroupFactory var1);
    }
}

