/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.nio.netty.NettySdkHttpClientFactory;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.NumericUtils;

@Immutable
public final class NettyConfiguration {
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(60L);
    private final AttributeMap serviceDefaults;
    private final NettySdkHttpClientFactory factory;

    public NettyConfiguration(AttributeMap serviceDefaults, NettySdkHttpClientFactory factory) {
        this.serviceDefaults = serviceDefaults;
        this.factory = factory;
    }

    public int connectionTimeout() {
        return NumericUtils.saturatedCast((long)((Duration)this.serviceDefaults.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis());
    }

    public int maxConnectionsPerEndpoint() {
        return (Integer)this.serviceDefaults.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
    }

    @ReviewBeforeRelease(value="Support disabling strict hostname verification")
    public <T> Optional<T> getConfigurationValue(AttributeMap.Key<T> key) {
        return key == SdkHttpConfigurationOption.USE_STRICT_HOSTNAME_VERIFICATION ? Optional.empty() : Optional.ofNullable(this.serviceDefaults.get(key));
    }

    public int readTimeout() {
        return NumericUtils.saturatedCast((long)this.factory.readTimeout().orElse(DEFAULT_READ_TIMEOUT).getSeconds());
    }

    public int writeTimeout() {
        return NumericUtils.saturatedCast((long)this.factory.writeTimeout().orElse(DEFAULT_WRITE_TIMEOUT).getSeconds());
    }

    public int connectionAcquisitionTimeout() {
        return this.factory.connectionAquisitionTimeout().map(d -> NumericUtils.saturatedCast((long)d.toMillis())).orElseGet(this::connectionTimeout);
    }

    public boolean trustAllCertificates() {
        return this.factory.trustAllCertificates().orElse(Boolean.FALSE);
    }
}

