/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.HandlerSubscriber;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;

public class NettyHttpContentSubscriber
extends HandlerSubscriber<HttpContent> {
    private final Channel channel;

    public NettyHttpContentSubscriber(Channel channel) {
        super((EventExecutor)channel.eventLoop());
        this.channel = channel;
    }

    protected void complete() {
        EventLoop executor = this.channel.eventLoop();
        executor.execute(() -> this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.removeFromPipeline())));
    }

    protected void error(Throwable error) {
        this.removeFromPipeline();
    }

    private void removeFromPipeline() {
        this.channel.pipeline().remove((ChannelHandler)this);
    }

    public Subscriber<ByteBuffer> adapt() {
        return new SubscriberAdapter((Subscriber)this);
    }

    private class SubscriberAdapter
    implements Subscriber<ByteBuffer> {
        private final Subscriber<HttpContent> subscriber;

        private SubscriberAdapter(Subscriber<HttpContent> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        @ReviewBeforeRelease(value="Unpooled vs channel.alloc? channel.alloc seems to be preferred but we should test this more thoroughly under high concurrency.")
        public void onNext(ByteBuffer data) {
            ByteBuf buffer = NettyHttpContentSubscriber.this.channel.alloc().buffer(data.limit());
            buffer.writeBytes(data);
            DefaultHttpContent content = new DefaultHttpContent(buffer);
            this.subscriber.onNext((Object)content);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

