/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.http2.MultiplexedChannelRecord;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;

@SdkInternalApi
public class Http2MultiplexedChannelPool
implements ChannelPool {
    private final EventLoop eventLoop;
    private final ChannelPool connectionPool;
    private final long maxConcurrencyPerConnection;
    private final ArrayList<MultiplexedChannelRecord> connections;

    Http2MultiplexedChannelPool(ChannelPool connectionPool, EventLoop eventLoop, long maxConcurrencyPerConnection) {
        this.connectionPool = connectionPool;
        this.eventLoop = eventLoop;
        this.maxConcurrencyPerConnection = maxConcurrencyPerConnection;
        this.connections = new ArrayList();
    }

    public Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)new DefaultPromise((EventExecutor)this.eventLoop));
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.acquire0(promise), promise);
        return promise;
    }

    private Future<Channel> acquire0(Promise<Channel> promise) {
        for (MultiplexedChannelRecord connection : this.connections) {
            if (connection.availableStreams() <= 0L) continue;
            connection.acquire(promise);
            return promise;
        }
        this.connections.add(new MultiplexedChannelRecord((Future<Channel>)this.connectionPool.acquire(), this.maxConcurrencyPerConnection, this::releaseParentChannel).acquire(promise));
        return promise;
    }

    private void releaseParentChannel(Channel parentChannel, MultiplexedChannelRecord record) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.releaseParentChannel0(parentChannel, record));
    }

    private void releaseParentChannel0(Channel parentChannel, MultiplexedChannelRecord record) {
        if (parentChannel != null) {
            try {
                parentChannel.close();
            }
            finally {
                this.connectionPool.release(parentChannel);
            }
        }
        this.connections.remove(record);
    }

    public Future<Void> release(Channel childChannel) {
        return this.release(childChannel, (Promise<Void>)new DefaultPromise((EventExecutor)this.eventLoop));
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.release0(channel, promise), promise);
        return promise;
    }

    private void release0(Channel channel, Promise<Void> promise) {
        if (channel.parent() == null) {
            try {
                this.releaseParentChannel(channel);
            }
            finally {
                promise.setFailure((Throwable)new IllegalArgumentException("Channel does not belong to this pool"));
            }
        } else {
            Channel parentChannel = channel.parent();
            MultiplexedChannelRecord channelRecord = (MultiplexedChannelRecord)parentChannel.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).get();
            channelRecord.release(channel);
            channel.close();
            promise.setSuccess(null);
        }
    }

    private void releaseParentChannel(Channel parentChannel) {
        MultiplexedChannelRecord channelRecord = (MultiplexedChannelRecord)parentChannel.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).get();
        this.connections.remove(channelRecord);
        parentChannel.close();
        this.connectionPool.release(parentChannel);
    }

    public void close() {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> ((ChannelPool)this.connectionPool).close());
    }
}

