/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.QueryStateInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueriesRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, ListQueriesRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(ListQueriesRequest.getter(ListQueriesRequest::graphIdentifier)).setter(ListQueriesRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("graphIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListQueriesRequest.getter(ListQueriesRequest::maxResults)).setter(ListQueriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ListQueriesRequest.getter(ListQueriesRequest::stateAsString)).setter(ListQueriesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueriesRequest.memberNameToFieldInitializer();
    private final String graphIdentifier;
    private final Integer maxResults;
    private final String state;

    private ListQueriesRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.maxResults = builder.maxResults;
        this.state = builder.state;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final QueryStateInput state() {
        return QueryStateInput.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueriesRequest)) {
            return false;
        }
        ListQueriesRequest other = (ListQueriesRequest)((Object)obj);
        return Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueriesRequest").add("GraphIdentifier", (Object)this.graphIdentifier()).add("MaxResults", (Object)this.maxResults()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueriesRequest, T> g) {
        return obj -> g.apply((ListQueriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphIdentifier;
        private Integer maxResults;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueriesRequest model) {
            super(model);
            this.graphIdentifier(model.graphIdentifier);
            this.maxResults(model.maxResults);
            this.state(model.state);
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryStateInput state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueriesRequest build() {
            return new ListQueriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueriesRequest> {
        public Builder graphIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder state(String var1);

        public Builder state(QueryStateInput var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

