/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilter;
import software.amazon.awssdk.services.neptunegraph.model.ExportFormat;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ParquetType;
import software.amazon.awssdk.services.neptunegraph.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportTaskRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, StartExportTaskRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(StartExportTaskRequest.getter(StartExportTaskRequest::graphIdentifier)).setter(StartExportTaskRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphIdentifier").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartExportTaskRequest.getter(StartExportTaskRequest::roleArn)).setter(StartExportTaskRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(StartExportTaskRequest.getter(StartExportTaskRequest::formatAsString)).setter(StartExportTaskRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(StartExportTaskRequest.getter(StartExportTaskRequest::destination)).setter(StartExportTaskRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(StartExportTaskRequest.getter(StartExportTaskRequest::kmsKeyIdentifier)).setter(StartExportTaskRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parquetType").getter(StartExportTaskRequest.getter(StartExportTaskRequest::parquetTypeAsString)).setter(StartExportTaskRequest.setter(Builder::parquetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()}).build();
    private static final SdkField<ExportFilter> EXPORT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exportFilter").getter(StartExportTaskRequest.getter(StartExportTaskRequest::exportFilter)).setter(StartExportTaskRequest.setter(Builder::exportFilter)).constructor(ExportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportFilter").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartExportTaskRequest.getter(StartExportTaskRequest::tags)).setter(StartExportTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD, ROLE_ARN_FIELD, FORMAT_FIELD, DESTINATION_FIELD, KMS_KEY_IDENTIFIER_FIELD, PARQUET_TYPE_FIELD, EXPORT_FILTER_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartExportTaskRequest.memberNameToFieldInitializer();
    private final String graphIdentifier;
    private final String roleArn;
    private final String format;
    private final String destination;
    private final String kmsKeyIdentifier;
    private final String parquetType;
    private final ExportFilter exportFilter;
    private final Map<String, String> tags;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.roleArn = builder.roleArn;
        this.format = builder.format;
        this.destination = builder.destination;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.parquetType = builder.parquetType;
        this.exportFilter = builder.exportFilter;
        this.tags = builder.tags;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ExportFormat format() {
        return ExportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String destination() {
        return this.destination;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final ParquetType parquetType() {
        return ParquetType.fromValue(this.parquetType);
    }

    public final String parquetTypeAsString() {
        return this.parquetType;
    }

    public final ExportFilter exportFilter() {
        return this.exportFilter;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)((Object)obj);
        return Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.parquetTypeAsString(), other.parquetTypeAsString()) && Objects.equals(this.exportFilter(), other.exportFilter()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartExportTaskRequest").add("GraphIdentifier", (Object)this.graphIdentifier()).add("RoleArn", (Object)this.roleArn()).add("Format", (Object)this.formatAsString()).add("Destination", (Object)this.destination()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("ParquetType", (Object)this.parquetTypeAsString()).add("ExportFilter", (Object)this.exportFilter()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "parquetType": {
                return Optional.ofNullable(clazz.cast(this.parquetTypeAsString()));
            }
            case "exportFilter": {
                return Optional.ofNullable(clazz.cast(this.exportFilter()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("exportFilter", EXPORT_FILTER_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphIdentifier;
        private String roleArn;
        private String format;
        private String destination;
        private String kmsKeyIdentifier;
        private String parquetType;
        private ExportFilter exportFilter;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            this.graphIdentifier(model.graphIdentifier);
            this.roleArn(model.roleArn);
            this.format(model.format);
            this.destination(model.destination);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.parquetType(model.parquetType);
            this.exportFilter(model.exportFilter);
            this.tags(model.tags);
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ExportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getParquetType() {
            return this.parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final ExportFilter.Builder getExportFilter() {
            return this.exportFilter != null ? this.exportFilter.toBuilder() : null;
        }

        public final void setExportFilter(ExportFilter.BuilderImpl exportFilter) {
            this.exportFilter = exportFilter != null ? exportFilter.build() : null;
        }

        @Override
        public final Builder exportFilter(ExportFilter exportFilter) {
            this.exportFilter = exportFilter;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportTaskRequest> {
        public Builder graphIdentifier(String var1);

        public Builder roleArn(String var1);

        public Builder format(String var1);

        public Builder format(ExportFormat var1);

        public Builder destination(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder parquetType(String var1);

        public Builder parquetType(ParquetType var1);

        public Builder exportFilter(ExportFilter var1);

        default public Builder exportFilter(Consumer<ExportFilter.Builder> exportFilter) {
            return this.exportFilter((ExportFilter)((ExportFilter.Builder)ExportFilter.builder().applyMutation(exportFilter)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

