/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptunegraph.endpoints.NeptuneGraphEndpointParams;
import software.amazon.awssdk.services.neptunegraph.endpoints.NeptuneGraphEndpointProvider;
import software.amazon.awssdk.services.neptunegraph.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.neptunegraph.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.neptunegraph.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultNeptuneGraphEndpointProvider
implements NeptuneGraphEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(NeptuneGraphEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.apiType(), (String)"Parameter 'ApiType' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(NeptuneGraphEndpointParams params, LocalState locals) {
        RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultNeptuneGraphEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultNeptuneGraphEndpointProvider.endpointRule28(params, locals);
    }

    private static RuleResult endpointRule1(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(NeptuneGraphEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultNeptuneGraphEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(NeptuneGraphEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule25(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule26(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule12(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(NeptuneGraphEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule11(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("ControlPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://neptune-graph-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("DataPlane".equals(params.apiType())) {
            return RuleResult.error("Invalid Configuration: fips endpoint is not supported for this API");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Unknown ApiType");
    }

    private static RuleResult endpointRule12(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule13(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(NeptuneGraphEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("ControlPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://neptune-graph-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("DataPlane".equals(params.apiType())) {
            return RuleResult.error("Invalid Configuration: fips endpoint is not supported for this API");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Unknown ApiType");
    }

    private static RuleResult endpointRule18(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule19(NeptuneGraphEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(NeptuneGraphEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultNeptuneGraphEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultNeptuneGraphEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultNeptuneGraphEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("ControlPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://neptune-graph." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("DataPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://neptune-graph." + locals.region() + ".on.aws")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Unknown ApiType");
    }

    private static RuleResult endpointRule24(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule25(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("ControlPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://neptune-graph." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(NeptuneGraphEndpointParams params, LocalState locals) {
        if ("DataPlane".equals(params.apiType())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.region() + ".neptune-graph." + locals.partitionResult().dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Unknown ApiType");
    }

    private static RuleResult endpointRule28(NeptuneGraphEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

