/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ExportTaskSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListExportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListExportTasksResponse;

public class ListExportTasksPublisher
implements SdkPublisher<ListExportTasksResponse> {
    private final NeptuneGraphAsyncClient client;
    private final ListExportTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportTasksPublisher(NeptuneGraphAsyncClient client, ListExportTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportTasksPublisher(NeptuneGraphAsyncClient client, ListExportTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportTaskSummary> tasks() {
        Function<ListExportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExportTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExportTasksResponseFetcher
    implements AsyncPageFetcher<ListExportTasksResponse> {
        private ListExportTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListExportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExportTasksResponse> nextPage(ListExportTasksResponse previousPage) {
            if (previousPage == null) {
                return ListExportTasksPublisher.this.client.listExportTasks(ListExportTasksPublisher.this.firstRequest);
            }
            return ListExportTasksPublisher.this.client.listExportTasks((ListExportTasksRequest)((Object)ListExportTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

