/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneImportOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportOptions> {
    private static final SdkField<NeptuneImportOptions> NEPTUNE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("neptune").getter(ImportOptions.getter(ImportOptions::neptune)).setter(ImportOptions.setter(Builder::neptune)).constructor(NeptuneImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptune").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEPTUNE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("neptune", NEPTUNE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final NeptuneImportOptions neptune;
    private final Type type;

    private ImportOptions(BuilderImpl builder) {
        this.neptune = builder.neptune;
        this.type = builder.type;
    }

    public final NeptuneImportOptions neptune() {
        return this.neptune;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.neptune());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportOptions)) {
            return false;
        }
        ImportOptions other = (ImportOptions)obj;
        return Objects.equals(this.neptune(), other.neptune());
    }

    public final String toString() {
        return ToString.builder((String)"ImportOptions").add("Neptune", (Object)this.neptune()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "neptune": {
                return Optional.ofNullable(clazz.cast(this.neptune()));
            }
        }
        return Optional.empty();
    }

    public static ImportOptions fromNeptune(NeptuneImportOptions neptune) {
        return (ImportOptions)ImportOptions.builder().neptune(neptune).build();
    }

    public static ImportOptions fromNeptune(Consumer<NeptuneImportOptions.Builder> neptune) {
        NeptuneImportOptions.Builder builder = NeptuneImportOptions.builder();
        neptune.accept(builder);
        return ImportOptions.fromNeptune((NeptuneImportOptions)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportOptions, T> g) {
        return obj -> g.apply((ImportOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NEPTUNE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NeptuneImportOptions neptune;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImportOptions model) {
            this.neptune(model.neptune);
        }

        public final NeptuneImportOptions.Builder getNeptune() {
            return this.neptune != null ? this.neptune.toBuilder() : null;
        }

        public final void setNeptune(NeptuneImportOptions.BuilderImpl neptune) {
            NeptuneImportOptions oldValue = this.neptune;
            this.neptune = neptune != null ? neptune.build() : null;
            this.handleUnionValueChange(Type.NEPTUNE, oldValue, this.neptune);
        }

        @Override
        public final Builder neptune(NeptuneImportOptions neptune) {
            NeptuneImportOptions oldValue = this.neptune;
            this.neptune = neptune;
            this.handleUnionValueChange(Type.NEPTUNE, oldValue, this.neptune);
            return this;
        }

        public ImportOptions build() {
            return new ImportOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportOptions> {
        public Builder neptune(NeptuneImportOptions var1);

        default public Builder neptune(Consumer<NeptuneImportOptions.Builder> neptune) {
            return this.neptune((NeptuneImportOptions)((NeptuneImportOptions.Builder)NeptuneImportOptions.builder().applyMutation(neptune)).build());
        }
    }
}

