/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.BlankNodeHandling;
import software.amazon.awssdk.services.neptunegraph.model.Format;
import software.amazon.awssdk.services.neptunegraph.model.ImportOptions;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportTaskRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, StartImportTaskRequest> {
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importOptions").getter(StartImportTaskRequest.getter(StartImportTaskRequest::importOptions)).setter(StartImportTaskRequest.setter(Builder::importOptions)).constructor(ImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("failOnError").getter(StartImportTaskRequest.getter(StartImportTaskRequest::failOnError)).setter(StartImportTaskRequest.setter(Builder::failOnError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(StartImportTaskRequest.getter(StartImportTaskRequest::source)).setter(StartImportTaskRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(StartImportTaskRequest.getter(StartImportTaskRequest::formatAsString)).setter(StartImportTaskRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> BLANK_NODE_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blankNodeHandling").getter(StartImportTaskRequest.getter(StartImportTaskRequest::blankNodeHandlingAsString)).setter(StartImportTaskRequest.setter(Builder::blankNodeHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blankNodeHandling").build()}).build();
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(StartImportTaskRequest.getter(StartImportTaskRequest::graphIdentifier)).setter(StartImportTaskRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("graphIdentifier").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartImportTaskRequest.getter(StartImportTaskRequest::roleArn)).setter(StartImportTaskRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_OPTIONS_FIELD, FAIL_ON_ERROR_FIELD, SOURCE_FIELD, FORMAT_FIELD, BLANK_NODE_HANDLING_FIELD, GRAPH_IDENTIFIER_FIELD, ROLE_ARN_FIELD));
    private final ImportOptions importOptions;
    private final Boolean failOnError;
    private final String source;
    private final String format;
    private final String blankNodeHandling;
    private final String graphIdentifier;
    private final String roleArn;

    private StartImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.importOptions = builder.importOptions;
        this.failOnError = builder.failOnError;
        this.source = builder.source;
        this.format = builder.format;
        this.blankNodeHandling = builder.blankNodeHandling;
        this.graphIdentifier = builder.graphIdentifier;
        this.roleArn = builder.roleArn;
    }

    public final ImportOptions importOptions() {
        return this.importOptions;
    }

    public final Boolean failOnError() {
        return this.failOnError;
    }

    public final String source() {
        return this.source;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final BlankNodeHandling blankNodeHandling() {
        return BlankNodeHandling.fromValue(this.blankNodeHandling);
    }

    public final String blankNodeHandlingAsString() {
        return this.blankNodeHandling;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blankNodeHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportTaskRequest)) {
            return false;
        }
        StartImportTaskRequest other = (StartImportTaskRequest)((Object)obj);
        return Objects.equals(this.importOptions(), other.importOptions()) && Objects.equals(this.failOnError(), other.failOnError()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.blankNodeHandlingAsString(), other.blankNodeHandlingAsString()) && Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportTaskRequest").add("ImportOptions", (Object)this.importOptions()).add("FailOnError", (Object)this.failOnError()).add("Source", (Object)this.source()).add("Format", (Object)this.formatAsString()).add("BlankNodeHandling", (Object)this.blankNodeHandlingAsString()).add("GraphIdentifier", (Object)this.graphIdentifier()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importOptions": {
                return Optional.ofNullable(clazz.cast(this.importOptions()));
            }
            case "failOnError": {
                return Optional.ofNullable(clazz.cast(this.failOnError()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "blankNodeHandling": {
                return Optional.ofNullable(clazz.cast(this.blankNodeHandlingAsString()));
            }
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportTaskRequest, T> g) {
        return obj -> g.apply((StartImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private ImportOptions importOptions;
        private Boolean failOnError;
        private String source;
        private String format;
        private String blankNodeHandling;
        private String graphIdentifier;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportTaskRequest model) {
            super(model);
            this.importOptions(model.importOptions);
            this.failOnError(model.failOnError);
            this.source(model.source);
            this.format(model.format);
            this.blankNodeHandling(model.blankNodeHandling);
            this.graphIdentifier(model.graphIdentifier);
            this.roleArn(model.roleArn);
        }

        public final ImportOptions.Builder getImportOptions() {
            return this.importOptions != null ? this.importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final Boolean getFailOnError() {
            return this.failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getBlankNodeHandling() {
            return this.blankNodeHandling;
        }

        public final void setBlankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
        }

        @Override
        public final Builder blankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
            return this;
        }

        @Override
        public final Builder blankNodeHandling(BlankNodeHandling blankNodeHandling) {
            this.blankNodeHandling(blankNodeHandling == null ? null : blankNodeHandling.toString());
            return this;
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportTaskRequest build() {
            return new StartImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportTaskRequest> {
        public Builder importOptions(ImportOptions var1);

        default public Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return this.importOptions((ImportOptions)((ImportOptions.Builder)ImportOptions.builder().applyMutation(importOptions)).build());
        }

        public Builder failOnError(Boolean var1);

        public Builder source(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder blankNodeHandling(String var1);

        public Builder blankNodeHandling(BlankNodeHandling var1);

        public Builder graphIdentifier(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

