/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.Format;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskStatus;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelImportTaskResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, CancelImportTaskResponse> {
    private static final SdkField<String> GRAPH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphId").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::graphId)).setter(CancelImportTaskResponse.setter(Builder::graphId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::taskId)).setter(CancelImportTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::source)).setter(CancelImportTaskResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::formatAsString)).setter(CancelImportTaskResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::roleArn)).setter(CancelImportTaskResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CancelImportTaskResponse.getter(CancelImportTaskResponse::statusAsString)).setter(CancelImportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ID_FIELD, TASK_ID_FIELD, SOURCE_FIELD, FORMAT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD));
    private final String graphId;
    private final String taskId;
    private final String source;
    private final String format;
    private final String roleArn;
    private final String status;

    private CancelImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.graphId = builder.graphId;
        this.taskId = builder.taskId;
        this.source = builder.source;
        this.format = builder.format;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
    }

    public final String graphId() {
        return this.graphId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String source() {
        return this.source;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ImportTaskStatus status() {
        return ImportTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskResponse)) {
            return false;
        }
        CancelImportTaskResponse other = (CancelImportTaskResponse)((Object)obj);
        return Objects.equals(this.graphId(), other.graphId()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CancelImportTaskResponse").add("GraphId", (Object)this.graphId()).add("TaskId", (Object)this.taskId()).add("Source", (Object)this.source()).add("Format", (Object)this.formatAsString()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphId": {
                return Optional.ofNullable(clazz.cast(this.graphId()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelImportTaskResponse, T> g) {
        return obj -> g.apply((CancelImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String graphId;
        private String taskId;
        private String source;
        private String format;
        private String roleArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskResponse model) {
            super(model);
            this.graphId(model.graphId);
            this.taskId(model.taskId);
            this.source(model.source);
            this.format(model.format);
            this.roleArn(model.roleArn);
            this.status(model.status);
        }

        public final String getGraphId() {
            return this.graphId;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        @Override
        public final Builder graphId(String graphId) {
            this.graphId = graphId;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CancelImportTaskResponse build() {
            return new CancelImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelImportTaskResponse> {
        public Builder graphId(String var1);

        public Builder taskId(String var1);

        public Builder source(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ImportTaskStatus var1);
    }
}

