/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.GraphSummary;
import software.amazon.awssdk.services.neptunegraph.model.GraphSummaryListCopier;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGraphsResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, ListGraphsResponse> {
    private static final SdkField<List<GraphSummary>> GRAPHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("graphs").getter(ListGraphsResponse.getter(ListGraphsResponse::graphs)).setter(ListGraphsResponse.setter(Builder::graphs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GraphSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGraphsResponse.getter(ListGraphsResponse::nextToken)).setter(ListGraphsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPHS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GraphSummary> graphs;
    private final String nextToken;

    private ListGraphsResponse(BuilderImpl builder) {
        super(builder);
        this.graphs = builder.graphs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGraphs() {
        return this.graphs != null && !(this.graphs instanceof SdkAutoConstructList);
    }

    public final List<GraphSummary> graphs() {
        return this.graphs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGraphs() ? this.graphs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphsResponse)) {
            return false;
        }
        ListGraphsResponse other = (ListGraphsResponse)((Object)obj);
        return this.hasGraphs() == other.hasGraphs() && Objects.equals(this.graphs(), other.graphs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGraphsResponse").add("Graphs", this.hasGraphs() ? this.graphs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphs": {
                return Optional.ofNullable(clazz.cast(this.graphs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGraphsResponse, T> g) {
        return obj -> g.apply((ListGraphsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private List<GraphSummary> graphs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphsResponse model) {
            super(model);
            this.graphs(model.graphs);
            this.nextToken(model.nextToken);
        }

        public final List<GraphSummary.Builder> getGraphs() {
            List<GraphSummary.Builder> result = GraphSummaryListCopier.copyToBuilder(this.graphs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGraphs(Collection<GraphSummary.BuilderImpl> graphs) {
            this.graphs = GraphSummaryListCopier.copyFromBuilder(graphs);
        }

        @Override
        public final Builder graphs(Collection<GraphSummary> graphs) {
            this.graphs = GraphSummaryListCopier.copy(graphs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphs(GraphSummary ... graphs) {
            this.graphs(Arrays.asList(graphs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphs(Consumer<GraphSummary.Builder> ... graphs) {
            this.graphs(Stream.of(graphs).map(c -> (GraphSummary)((GraphSummary.Builder)GraphSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGraphsResponse build() {
            return new ListGraphsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGraphsResponse> {
        public Builder graphs(Collection<GraphSummary> var1);

        public Builder graphs(GraphSummary ... var1);

        public Builder graphs(Consumer<GraphSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

