/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphWaiter;
import software.amazon.awssdk.services.neptunegraph.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultNeptuneGraphWaiter
implements NeptuneGraphWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final NeptuneGraphClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetGraphResponse> graphAvailableWaiter;
    private final Waiter<GetGraphResponse> graphDeletedWaiter;
    private final Waiter<GetGraphSnapshotResponse> graphSnapshotAvailableWaiter;
    private final Waiter<GetGraphSnapshotResponse> graphSnapshotDeletedWaiter;
    private final Waiter<GetImportTaskResponse> importTaskCancelledWaiter;
    private final Waiter<GetImportTaskResponse> importTaskSuccessfulWaiter;
    private final Waiter<GetPrivateGraphEndpointResponse> privateGraphEndpointAvailableWaiter;
    private final Waiter<GetPrivateGraphEndpointResponse> privateGraphEndpointDeletedWaiter;

    private DefaultNeptuneGraphWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (NeptuneGraphClient)NeptuneGraphClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.graphAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetGraphResponse.class).acceptors(DefaultNeptuneGraphWaiter.graphAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.graphAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.graphDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetGraphResponse.class).acceptors(DefaultNeptuneGraphWaiter.graphDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.graphDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.graphSnapshotAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetGraphSnapshotResponse.class).acceptors(DefaultNeptuneGraphWaiter.graphSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.graphSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.graphSnapshotDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetGraphSnapshotResponse.class).acceptors(DefaultNeptuneGraphWaiter.graphSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.graphSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.importTaskCancelledWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetImportTaskResponse.class).acceptors(DefaultNeptuneGraphWaiter.importTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.importTaskCancelledWaiterConfig(builder.overrideConfiguration))).build();
        this.importTaskSuccessfulWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetImportTaskResponse.class).acceptors(DefaultNeptuneGraphWaiter.importTaskSuccessfulWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.importTaskSuccessfulWaiterConfig(builder.overrideConfiguration))).build();
        this.privateGraphEndpointAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPrivateGraphEndpointResponse.class).acceptors(DefaultNeptuneGraphWaiter.privateGraphEndpointAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.privateGraphEndpointAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.privateGraphEndpointDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPrivateGraphEndpointResponse.class).acceptors(DefaultNeptuneGraphWaiter.privateGraphEndpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphWaiter.privateGraphEndpointDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(GetGraphRequest getGraphRequest) {
        return this.graphAvailableWaiter.run(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)));
    }

    @Override
    public WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphAvailableWaiter.run(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)), DefaultNeptuneGraphWaiter.graphAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(GetGraphRequest getGraphRequest) {
        return this.graphDeletedWaiter.run(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)));
    }

    @Override
    public WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphDeletedWaiter.run(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)), DefaultNeptuneGraphWaiter.graphDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        return this.graphSnapshotAvailableWaiter.run(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)));
    }

    @Override
    public WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphSnapshotAvailableWaiter.run(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)), DefaultNeptuneGraphWaiter.graphSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        return this.graphSnapshotDeletedWaiter.run(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)));
    }

    @Override
    public WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphSnapshotDeletedWaiter.run(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)), DefaultNeptuneGraphWaiter.graphSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest) {
        return this.importTaskCancelledWaiter.run(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)));
    }

    @Override
    public WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.importTaskCancelledWaiter.run(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)), DefaultNeptuneGraphWaiter.importTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest) {
        return this.importTaskSuccessfulWaiter.run(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)));
    }

    @Override
    public WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.importTaskSuccessfulWaiter.run(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)), DefaultNeptuneGraphWaiter.importTaskSuccessfulWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        return this.privateGraphEndpointAvailableWaiter.run(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)));
    }

    @Override
    public WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.privateGraphEndpointAvailableWaiter.run(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)), DefaultNeptuneGraphWaiter.privateGraphEndpointAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        return this.privateGraphEndpointDeletedWaiter.run(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)));
    }

    @Override
    public WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.privateGraphEndpointDeletedWaiter.run(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)), DefaultNeptuneGraphWaiter.privateGraphEndpointDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetGraphResponse>> graphAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphResponse>> graphDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphSnapshotResponse>> graphSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphSnapshotResponse>> graphSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetImportTaskResponse>> importTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetImportTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetImportTaskResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("CANCELLING")).and(input.field("status").compare("!=", input.constant("CANCELLED"))).value(), true);
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetImportTaskResponse>> importTaskSuccessfulWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetImportTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetImportTaskResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ROLLING_BACK");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUCCEEDED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> privateGraphEndpointAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> privateGraphEndpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration graphAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(480);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration importTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration importTaskSuccessfulWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(480);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration privateGraphEndpointAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration privateGraphEndpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static NeptuneGraphWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends NeptuneGraphRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NeptuneGraphRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements NeptuneGraphWaiter.Builder {
        private NeptuneGraphClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public NeptuneGraphWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public NeptuneGraphWaiter.Builder client(NeptuneGraphClient client) {
            this.client = client;
            return this;
        }

        @Override
        public NeptuneGraphWaiter build() {
            return new DefaultNeptuneGraphWaiter(this);
        }
    }
}

