/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGraphSnapshotRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, CreateGraphSnapshotRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(CreateGraphSnapshotRequest.getter(CreateGraphSnapshotRequest::graphIdentifier)).setter(CreateGraphSnapshotRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(CreateGraphSnapshotRequest.getter(CreateGraphSnapshotRequest::snapshotName)).setter(CreateGraphSnapshotRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateGraphSnapshotRequest.getter(CreateGraphSnapshotRequest::tags)).setter(CreateGraphSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD, SNAPSHOT_NAME_FIELD, TAGS_FIELD));
    private final String graphIdentifier;
    private final String snapshotName;
    private final Map<String, String> tags;

    private CreateGraphSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.snapshotName = builder.snapshotName;
        this.tags = builder.tags;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphSnapshotRequest)) {
            return false;
        }
        CreateGraphSnapshotRequest other = (CreateGraphSnapshotRequest)((Object)obj);
        return Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.snapshotName(), other.snapshotName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGraphSnapshotRequest").add("GraphIdentifier", (Object)this.graphIdentifier()).add("SnapshotName", (Object)this.snapshotName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphSnapshotRequest, T> g) {
        return obj -> g.apply((CreateGraphSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphIdentifier;
        private String snapshotName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphSnapshotRequest model) {
            super(model);
            this.graphIdentifier(model.graphIdentifier);
            this.snapshotName(model.snapshotName);
            this.tags(model.tags);
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphSnapshotRequest build() {
            return new CreateGraphSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGraphSnapshotRequest> {
        public Builder graphIdentifier(String var1);

        public Builder snapshotName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

