/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary;
import software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrivateGraphEndpointsResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, ListPrivateGraphEndpointsResponse> {
    private static final SdkField<List<PrivateGraphEndpointSummary>> PRIVATE_GRAPH_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("privateGraphEndpoints").getter(ListPrivateGraphEndpointsResponse.getter(ListPrivateGraphEndpointsResponse::privateGraphEndpoints)).setter(ListPrivateGraphEndpointsResponse.setter(Builder::privateGraphEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateGraphEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateGraphEndpointSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPrivateGraphEndpointsResponse.getter(ListPrivateGraphEndpointsResponse::nextToken)).setter(ListPrivateGraphEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_GRAPH_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PrivateGraphEndpointSummary> privateGraphEndpoints;
    private final String nextToken;

    private ListPrivateGraphEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.privateGraphEndpoints = builder.privateGraphEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPrivateGraphEndpoints() {
        return this.privateGraphEndpoints != null && !(this.privateGraphEndpoints instanceof SdkAutoConstructList);
    }

    public final List<PrivateGraphEndpointSummary> privateGraphEndpoints() {
        return this.privateGraphEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateGraphEndpoints() ? this.privateGraphEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrivateGraphEndpointsResponse)) {
            return false;
        }
        ListPrivateGraphEndpointsResponse other = (ListPrivateGraphEndpointsResponse)((Object)obj);
        return this.hasPrivateGraphEndpoints() == other.hasPrivateGraphEndpoints() && Objects.equals(this.privateGraphEndpoints(), other.privateGraphEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPrivateGraphEndpointsResponse").add("PrivateGraphEndpoints", this.hasPrivateGraphEndpoints() ? this.privateGraphEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "privateGraphEndpoints": {
                return Optional.ofNullable(clazz.cast(this.privateGraphEndpoints()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrivateGraphEndpointsResponse, T> g) {
        return obj -> g.apply((ListPrivateGraphEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private List<PrivateGraphEndpointSummary> privateGraphEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrivateGraphEndpointsResponse model) {
            super(model);
            this.privateGraphEndpoints(model.privateGraphEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<PrivateGraphEndpointSummary.Builder> getPrivateGraphEndpoints() {
            List<PrivateGraphEndpointSummary.Builder> result = PrivateGraphEndpointSummaryListCopier.copyToBuilder(this.privateGraphEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateGraphEndpoints(Collection<PrivateGraphEndpointSummary.BuilderImpl> privateGraphEndpoints) {
            this.privateGraphEndpoints = PrivateGraphEndpointSummaryListCopier.copyFromBuilder(privateGraphEndpoints);
        }

        @Override
        public final Builder privateGraphEndpoints(Collection<PrivateGraphEndpointSummary> privateGraphEndpoints) {
            this.privateGraphEndpoints = PrivateGraphEndpointSummaryListCopier.copy(privateGraphEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateGraphEndpoints(PrivateGraphEndpointSummary ... privateGraphEndpoints) {
            this.privateGraphEndpoints(Arrays.asList(privateGraphEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateGraphEndpoints(Consumer<PrivateGraphEndpointSummary.Builder> ... privateGraphEndpoints) {
            this.privateGraphEndpoints(Stream.of(privateGraphEndpoints).map(c -> (PrivateGraphEndpointSummary)((PrivateGraphEndpointSummary.Builder)PrivateGraphEndpointSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrivateGraphEndpointsResponse build() {
            return new ListPrivateGraphEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrivateGraphEndpointsResponse> {
        public Builder privateGraphEndpoints(Collection<PrivateGraphEndpointSummary> var1);

        public Builder privateGraphEndpoints(PrivateGraphEndpointSummary ... var1);

        public Builder privateGraphEndpoints(Consumer<PrivateGraphEndpointSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

