/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlDataProcessingJobRequest extends NeptunedataRequest implements
        ToCopyableBuilder<StartMlDataProcessingJobRequest.Builder, StartMlDataProcessingJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartMlDataProcessingJobRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PREVIOUS_DATA_PROCESSING_JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("previousDataProcessingJobId")
            .getter(getter(StartMlDataProcessingJobRequest::previousDataProcessingJobId))
            .setter(setter(Builder::previousDataProcessingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousDataProcessingJobId")
                    .build()).build();

    private static final SdkField<String> INPUT_DATA_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputDataS3Location").getter(getter(StartMlDataProcessingJobRequest::inputDataS3Location))
            .setter(setter(Builder::inputDataS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataS3Location").build())
            .build();

    private static final SdkField<String> PROCESSED_DATA_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processedDataS3Location").getter(getter(StartMlDataProcessingJobRequest::processedDataS3Location))
            .setter(setter(Builder::processedDataS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedDataS3Location").build())
            .build();

    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sagemakerIamRoleArn").getter(getter(StartMlDataProcessingJobRequest::sagemakerIamRoleArn))
            .setter(setter(Builder::sagemakerIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build())
            .build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(StartMlDataProcessingJobRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()).build();

    private static final SdkField<String> PROCESSING_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processingInstanceType").getter(getter(StartMlDataProcessingJobRequest::processingInstanceType))
            .setter(setter(Builder::processingInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingInstanceType").build())
            .build();

    private static final SdkField<Integer> PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("processingInstanceVolumeSizeInGB")
            .getter(getter(StartMlDataProcessingJobRequest::processingInstanceVolumeSizeInGB))
            .setter(setter(Builder::processingInstanceVolumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingInstanceVolumeSizeInGB")
                    .build()).build();

    private static final SdkField<Integer> PROCESSING_TIME_OUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("processingTimeOutInSeconds")
            .getter(getter(StartMlDataProcessingJobRequest::processingTimeOutInSeconds))
            .setter(setter(Builder::processingTimeOutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingTimeOutInSeconds").build())
            .build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelType").getter(getter(StartMlDataProcessingJobRequest::modelType))
            .setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> CONFIG_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configFileName").getter(getter(StartMlDataProcessingJobRequest::configFileName))
            .setter(setter(Builder::configFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configFileName").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(StartMlDataProcessingJobRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(StartMlDataProcessingJobRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeEncryptionKMSKey").getter(getter(StartMlDataProcessingJobRequest::volumeEncryptionKMSKey))
            .setter(setter(Builder::volumeEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build())
            .build();

    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3OutputEncryptionKMSKey").getter(getter(StartMlDataProcessingJobRequest::s3OutputEncryptionKMSKey))
            .setter(setter(Builder::s3OutputEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PREVIOUS_DATA_PROCESSING_JOB_ID_FIELD, INPUT_DATA_S3_LOCATION_FIELD, PROCESSED_DATA_S3_LOCATION_FIELD,
            SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, PROCESSING_INSTANCE_TYPE_FIELD,
            PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, PROCESSING_TIME_OUT_IN_SECONDS_FIELD, MODEL_TYPE_FIELD,
            CONFIG_FILE_NAME_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD,
            S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String previousDataProcessingJobId;

    private final String inputDataS3Location;

    private final String processedDataS3Location;

    private final String sagemakerIamRoleArn;

    private final String neptuneIamRoleArn;

    private final String processingInstanceType;

    private final Integer processingInstanceVolumeSizeInGB;

    private final Integer processingTimeOutInSeconds;

    private final String modelType;

    private final String configFileName;

    private final List<String> subnets;

    private final List<String> securityGroupIds;

    private final String volumeEncryptionKMSKey;

    private final String s3OutputEncryptionKMSKey;

    private StartMlDataProcessingJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.previousDataProcessingJobId = builder.previousDataProcessingJobId;
        this.inputDataS3Location = builder.inputDataS3Location;
        this.processedDataS3Location = builder.processedDataS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.processingInstanceType = builder.processingInstanceType;
        this.processingInstanceVolumeSizeInGB = builder.processingInstanceVolumeSizeInGB;
        this.processingTimeOutInSeconds = builder.processingTimeOutInSeconds;
        this.modelType = builder.modelType;
        this.configFileName = builder.configFileName;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is an autogenerated UUID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job ID of a completed data processing job run on an earlier version of the data.
     * </p>
     * 
     * @return The job ID of a completed data processing job run on an earlier version of the data.
     */
    public final String previousDataProcessingJobId() {
        return previousDataProcessingJobId;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing
     * job.
     * </p>
     * 
     * @return The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
     *         processing job.
     */
    public final String inputDataS3Location() {
        return inputDataS3Location;
    }

    /**
     * <p>
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     * </p>
     * 
     * @return The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     */
    public final String processedDataS3Location() {
        return processedDataS3Location;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */
    public final String sagemakerIamRoleArn() {
        return sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
     * must be listed in your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf.
     *         This must be listed in your DB cluster parameter group or an error will occur.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    /**
     * <p>
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
     * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported
     * graph data on disk.
     * </p>
     * 
     * @return The type of ML instance used during data processing. Its memory should be large enough to hold the
     *         processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size
     *         of the exported graph data on disk.
     */
    public final String processingInstanceType() {
        return processingInstanceType;
    }

    /**
     * <p>
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * chooses the volume size automatically based on the data size.
     * </p>
     * 
     * @return The disk volume size of the processing instance. Both input data and processed data are stored on disk,
     *         so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *         Neptune ML chooses the volume size automatically based on the data size.
     */
    public final Integer processingInstanceVolumeSizeInGB() {
        return processingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     * </p>
     * 
     * @return Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     */
    public final Integer processingTimeOutInSeconds() {
        return processingTimeOutInSeconds;
    }

    /**
     * <p>
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
     * Neptune ML chooses the model type automatically based on the data.
     * </p>
     * 
     * @return One of the two model types that Neptune ML currently supports: heterogeneous graph models (
     *         <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not
     *         specified, Neptune ML chooses the model type automatically based on the data.
     */
    public final String modelType() {
        return modelType;
    }

    /**
     * <p>
     * A data specification file that describes how to load the exported graph data for training. The file is
     * automatically generated by the Neptune export toolkit. The default is
     * <code>training-data-configuration.json</code>.
     * </p>
     * 
     * @return A data specification file that describes how to load the exported graph data for training. The file is
     *         automatically generated by the Neptune export toolkit. The default is
     *         <code>training-data-configuration.json</code>.
     */
    public final String configFileName() {
        return configFileName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
     *         volume attached to the ML compute instances that run the training job. The default is None.
     */
    public final String volumeEncryptionKMSKey() {
        return volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing
     * job. The default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
     *         processing job. The default is none.
     */
    public final String s3OutputEncryptionKMSKey() {
        return s3OutputEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(previousDataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(processedDataS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(processingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(processingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(processingTimeOutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(modelType());
        hashCode = 31 * hashCode + Objects.hashCode(configFileName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputEncryptionKMSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlDataProcessingJobRequest)) {
            return false;
        }
        StartMlDataProcessingJobRequest other = (StartMlDataProcessingJobRequest) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(previousDataProcessingJobId(), other.previousDataProcessingJobId())
                && Objects.equals(inputDataS3Location(), other.inputDataS3Location())
                && Objects.equals(processedDataS3Location(), other.processedDataS3Location())
                && Objects.equals(sagemakerIamRoleArn(), other.sagemakerIamRoleArn())
                && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn())
                && Objects.equals(processingInstanceType(), other.processingInstanceType())
                && Objects.equals(processingInstanceVolumeSizeInGB(), other.processingInstanceVolumeSizeInGB())
                && Objects.equals(processingTimeOutInSeconds(), other.processingTimeOutInSeconds())
                && Objects.equals(modelType(), other.modelType()) && Objects.equals(configFileName(), other.configFileName())
                && hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey())
                && Objects.equals(s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMlDataProcessingJobRequest").add("Id", id())
                .add("PreviousDataProcessingJobId", previousDataProcessingJobId())
                .add("InputDataS3Location", inputDataS3Location()).add("ProcessedDataS3Location", processedDataS3Location())
                .add("SagemakerIamRoleArn", sagemakerIamRoleArn()).add("NeptuneIamRoleArn", neptuneIamRoleArn())
                .add("ProcessingInstanceType", processingInstanceType())
                .add("ProcessingInstanceVolumeSizeInGB", processingInstanceVolumeSizeInGB())
                .add("ProcessingTimeOutInSeconds", processingTimeOutInSeconds()).add("ModelType", modelType())
                .add("ConfigFileName", configFileName()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("VolumeEncryptionKMSKey", volumeEncryptionKMSKey())
                .add("S3OutputEncryptionKMSKey", s3OutputEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "previousDataProcessingJobId":
            return Optional.ofNullable(clazz.cast(previousDataProcessingJobId()));
        case "inputDataS3Location":
            return Optional.ofNullable(clazz.cast(inputDataS3Location()));
        case "processedDataS3Location":
            return Optional.ofNullable(clazz.cast(processedDataS3Location()));
        case "sagemakerIamRoleArn":
            return Optional.ofNullable(clazz.cast(sagemakerIamRoleArn()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        case "processingInstanceType":
            return Optional.ofNullable(clazz.cast(processingInstanceType()));
        case "processingInstanceVolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(processingInstanceVolumeSizeInGB()));
        case "processingTimeOutInSeconds":
            return Optional.ofNullable(clazz.cast(processingTimeOutInSeconds()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelType()));
        case "configFileName":
            return Optional.ofNullable(clazz.cast(configFileName()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "volumeEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKMSKey()));
        case "s3OutputEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(s3OutputEncryptionKMSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("previousDataProcessingJobId", PREVIOUS_DATA_PROCESSING_JOB_ID_FIELD);
        map.put("inputDataS3Location", INPUT_DATA_S3_LOCATION_FIELD);
        map.put("processedDataS3Location", PROCESSED_DATA_S3_LOCATION_FIELD);
        map.put("sagemakerIamRoleArn", SAGEMAKER_IAM_ROLE_ARN_FIELD);
        map.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
        map.put("processingInstanceType", PROCESSING_INSTANCE_TYPE_FIELD);
        map.put("processingInstanceVolumeSizeInGB", PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD);
        map.put("processingTimeOutInSeconds", PROCESSING_TIME_OUT_IN_SECONDS_FIELD);
        map.put("modelType", MODEL_TYPE_FIELD);
        map.put("configFileName", CONFIG_FILE_NAME_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("volumeEncryptionKMSKey", VOLUME_ENCRYPTION_KMS_KEY_FIELD);
        map.put("s3OutputEncryptionKMSKey", S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMlDataProcessingJobRequest, T> g) {
        return obj -> g.apply((StartMlDataProcessingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlDataProcessingJobRequest> {
        /**
         * <p>
         * A unique identifier for the new job. The default is an autogenerated UUID.
         * </p>
         * 
         * @param id
         *        A unique identifier for the new job. The default is an autogenerated UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job ID of a completed data processing job run on an earlier version of the data.
         * </p>
         * 
         * @param previousDataProcessingJobId
         *        The job ID of a completed data processing job run on an earlier version of the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousDataProcessingJobId(String previousDataProcessingJobId);

        /**
         * <p>
         * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
         * processing job.
         * </p>
         * 
         * @param inputDataS3Location
         *        The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data
         *        processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataS3Location(String inputDataS3Location);

        /**
         * <p>
         * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
         * </p>
         * 
         * @param processedDataS3Location
         *        The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedDataS3Location(String processedDataS3Location);

        /**
         * <p>
         * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
         * error will occur.
         * </p>
         * 
         * @param sagemakerIamRoleArn
         *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group
         *        or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sagemakerIamRoleArn(String sagemakerIamRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This
         * must be listed in your DB cluster parameter group or an error will occur.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your
         *        behalf. This must be listed in your DB cluster parameter group or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        /**
         * <p>
         * The type of ML instance used during data processing. Its memory should be large enough to hold the processed
         * dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the
         * exported graph data on disk.
         * </p>
         * 
         * @param processingInstanceType
         *        The type of ML instance used during data processing. Its memory should be large enough to hold the
         *        processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the
         *        size of the exported graph data on disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInstanceType(String processingInstanceType);

        /**
         * <p>
         * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so
         * the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune
         * ML chooses the volume size automatically based on the data size.
         * </p>
         * 
         * @param processingInstanceVolumeSizeInGB
         *        The disk volume size of the processing instance. Both input data and processed data are stored on
         *        disk, so the volume size must be large enough to hold both data sets. The default is 0. If not
         *        specified or 0, Neptune ML chooses the volume size automatically based on the data size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB);

        /**
         * <p>
         * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
         * </p>
         * 
         * @param processingTimeOutInSeconds
         *        Timeout in seconds for the data processing job. The default is 86,400 (1 day).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTimeOutInSeconds(Integer processingTimeOutInSeconds);

        /**
         * <p>
         * One of the two model types that Neptune ML currently supports: heterogeneous graph models (
         * <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified,
         * Neptune ML chooses the model type automatically based on the data.
         * </p>
         * 
         * @param modelType
         *        One of the two model types that Neptune ML currently supports: heterogeneous graph models (
         *        <code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not
         *        specified, Neptune ML chooses the model type automatically based on the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * A data specification file that describes how to load the exported graph data for training. The file is
         * automatically generated by the Neptune export toolkit. The default is
         * <code>training-data-configuration.json</code>.
         * </p>
         * 
         * @param configFileName
         *        A data specification file that describes how to load the exported graph data for training. The file is
         *        automatically generated by the Neptune export toolkit. The default is
         *        <code>training-data-configuration.json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFileName(String configFileName);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instances that run the training job. The default is None.
         * </p>
         * 
         * @param volumeEncryptionKMSKey
         *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
         *        volume attached to the ML compute instances that run the training job. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey);

        /**
         * <p>
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
         * processing job. The default is none.
         * </p>
         * 
         * @param s3OutputEncryptionKMSKey
         *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the
         *        processing job. The default is none.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String id;

        private String previousDataProcessingJobId;

        private String inputDataS3Location;

        private String processedDataS3Location;

        private String sagemakerIamRoleArn;

        private String neptuneIamRoleArn;

        private String processingInstanceType;

        private Integer processingInstanceVolumeSizeInGB;

        private Integer processingTimeOutInSeconds;

        private String modelType;

        private String configFileName;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String volumeEncryptionKMSKey;

        private String s3OutputEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlDataProcessingJobRequest model) {
            super(model);
            id(model.id);
            previousDataProcessingJobId(model.previousDataProcessingJobId);
            inputDataS3Location(model.inputDataS3Location);
            processedDataS3Location(model.processedDataS3Location);
            sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
            processingInstanceType(model.processingInstanceType);
            processingInstanceVolumeSizeInGB(model.processingInstanceVolumeSizeInGB);
            processingTimeOutInSeconds(model.processingTimeOutInSeconds);
            modelType(model.modelType);
            configFileName(model.configFileName);
            subnets(model.subnets);
            securityGroupIds(model.securityGroupIds);
            volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPreviousDataProcessingJobId() {
            return previousDataProcessingJobId;
        }

        public final void setPreviousDataProcessingJobId(String previousDataProcessingJobId) {
            this.previousDataProcessingJobId = previousDataProcessingJobId;
        }

        @Override
        public final Builder previousDataProcessingJobId(String previousDataProcessingJobId) {
            this.previousDataProcessingJobId = previousDataProcessingJobId;
            return this;
        }

        public final String getInputDataS3Location() {
            return inputDataS3Location;
        }

        public final void setInputDataS3Location(String inputDataS3Location) {
            this.inputDataS3Location = inputDataS3Location;
        }

        @Override
        public final Builder inputDataS3Location(String inputDataS3Location) {
            this.inputDataS3Location = inputDataS3Location;
            return this;
        }

        public final String getProcessedDataS3Location() {
            return processedDataS3Location;
        }

        public final void setProcessedDataS3Location(String processedDataS3Location) {
            this.processedDataS3Location = processedDataS3Location;
        }

        @Override
        public final Builder processedDataS3Location(String processedDataS3Location) {
            this.processedDataS3Location = processedDataS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getProcessingInstanceType() {
            return processingInstanceType;
        }

        public final void setProcessingInstanceType(String processingInstanceType) {
            this.processingInstanceType = processingInstanceType;
        }

        @Override
        public final Builder processingInstanceType(String processingInstanceType) {
            this.processingInstanceType = processingInstanceType;
            return this;
        }

        public final Integer getProcessingInstanceVolumeSizeInGB() {
            return processingInstanceVolumeSizeInGB;
        }

        public final void setProcessingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
            this.processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder processingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
            this.processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB;
            return this;
        }

        public final Integer getProcessingTimeOutInSeconds() {
            return processingTimeOutInSeconds;
        }

        public final void setProcessingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
            this.processingTimeOutInSeconds = processingTimeOutInSeconds;
        }

        @Override
        public final Builder processingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
            this.processingTimeOutInSeconds = processingTimeOutInSeconds;
            return this;
        }

        public final String getModelType() {
            return modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public final String getConfigFileName() {
            return configFileName;
        }

        public final void setConfigFileName(String configFileName) {
            this.configFileName = configFileName;
        }

        @Override
        public final Builder configFileName(String configFileName) {
            this.configFileName = configFileName;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlDataProcessingJobRequest build() {
            return new StartMlDataProcessingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
