/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A node structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeStructure implements SdkPojo, Serializable, ToCopyableBuilder<NodeStructure.Builder, NodeStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(NodeStructure::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<String>> NODE_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nodeProperties")
            .getter(getter(NodeStructure::nodeProperties))
            .setter(setter(Builder::nodeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISTINCT_OUTGOING_EDGE_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("distinctOutgoingEdgeLabels")
            .getter(getter(NodeStructure::distinctOutgoingEdgeLabels))
            .setter(setter(Builder::distinctOutgoingEdgeLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distinctOutgoingEdgeLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            NODE_PROPERTIES_FIELD, DISTINCT_OUTGOING_EDGE_LABELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final List<String> nodeProperties;

    private final List<String> distinctOutgoingEdgeLabels;

    private NodeStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.nodeProperties = builder.nodeProperties;
        this.distinctOutgoingEdgeLabels = builder.distinctOutgoingEdgeLabels;
    }

    /**
     * <p>
     * Number of nodes that have this specific structure.
     * </p>
     * 
     * @return Number of nodes that have this specific structure.
     */
    public final Long count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeProperties() {
        return nodeProperties != null && !(nodeProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the node properties present in this specific structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeProperties} method.
     * </p>
     * 
     * @return A list of the node properties present in this specific structure.
     */
    public final List<String> nodeProperties() {
        return nodeProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the DistinctOutgoingEdgeLabels property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDistinctOutgoingEdgeLabels() {
        return distinctOutgoingEdgeLabels != null && !(distinctOutgoingEdgeLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of distinct outgoing edge labels present in this specific structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistinctOutgoingEdgeLabels} method.
     * </p>
     * 
     * @return A list of distinct outgoing edge labels present in this specific structure.
     */
    public final List<String> distinctOutgoingEdgeLabels() {
        return distinctOutgoingEdgeLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeProperties() ? nodeProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDistinctOutgoingEdgeLabels() ? distinctOutgoingEdgeLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeStructure)) {
            return false;
        }
        NodeStructure other = (NodeStructure) obj;
        return Objects.equals(count(), other.count()) && hasNodeProperties() == other.hasNodeProperties()
                && Objects.equals(nodeProperties(), other.nodeProperties())
                && hasDistinctOutgoingEdgeLabels() == other.hasDistinctOutgoingEdgeLabels()
                && Objects.equals(distinctOutgoingEdgeLabels(), other.distinctOutgoingEdgeLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeStructure").add("Count", count())
                .add("NodeProperties", hasNodeProperties() ? nodeProperties() : null)
                .add("DistinctOutgoingEdgeLabels", hasDistinctOutgoingEdgeLabels() ? distinctOutgoingEdgeLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "nodeProperties":
            return Optional.ofNullable(clazz.cast(nodeProperties()));
        case "distinctOutgoingEdgeLabels":
            return Optional.ofNullable(clazz.cast(distinctOutgoingEdgeLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("nodeProperties", NODE_PROPERTIES_FIELD);
        map.put("distinctOutgoingEdgeLabels", DISTINCT_OUTGOING_EDGE_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeStructure, T> g) {
        return obj -> g.apply((NodeStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeStructure> {
        /**
         * <p>
         * Number of nodes that have this specific structure.
         * </p>
         * 
         * @param count
         *        Number of nodes that have this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * A list of the node properties present in this specific structure.
         * </p>
         * 
         * @param nodeProperties
         *        A list of the node properties present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeProperties(Collection<String> nodeProperties);

        /**
         * <p>
         * A list of the node properties present in this specific structure.
         * </p>
         * 
         * @param nodeProperties
         *        A list of the node properties present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeProperties(String... nodeProperties);

        /**
         * <p>
         * A list of distinct outgoing edge labels present in this specific structure.
         * </p>
         * 
         * @param distinctOutgoingEdgeLabels
         *        A list of distinct outgoing edge labels present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels);

        /**
         * <p>
         * A list of distinct outgoing edge labels present in this specific structure.
         * </p>
         * 
         * @param distinctOutgoingEdgeLabels
         *        A list of distinct outgoing edge labels present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctOutgoingEdgeLabels(String... distinctOutgoingEdgeLabels);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private List<String> nodeProperties = DefaultSdkAutoConstructList.getInstance();

        private List<String> distinctOutgoingEdgeLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeStructure model) {
            count(model.count);
            nodeProperties(model.nodeProperties);
            distinctOutgoingEdgeLabels(model.distinctOutgoingEdgeLabels);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getNodeProperties() {
            if (nodeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeProperties;
        }

        public final void setNodeProperties(Collection<String> nodeProperties) {
            this.nodeProperties = NodePropertiesCopier.copy(nodeProperties);
        }

        @Override
        public final Builder nodeProperties(Collection<String> nodeProperties) {
            this.nodeProperties = NodePropertiesCopier.copy(nodeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeProperties(String... nodeProperties) {
            nodeProperties(Arrays.asList(nodeProperties));
            return this;
        }

        public final Collection<String> getDistinctOutgoingEdgeLabels() {
            if (distinctOutgoingEdgeLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return distinctOutgoingEdgeLabels;
        }

        public final void setDistinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels = OutgoingEdgeLabelsCopier.copy(distinctOutgoingEdgeLabels);
        }

        @Override
        public final Builder distinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels = OutgoingEdgeLabelsCopier.copy(distinctOutgoingEdgeLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distinctOutgoingEdgeLabels(String... distinctOutgoingEdgeLabels) {
            distinctOutgoingEdgeLabels(Arrays.asList(distinctOutgoingEdgeLabels));
            return this;
        }

        @Override
        public NodeStructure build() {
            return new NodeStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
