/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGremlinQueriesRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ListGremlinQueriesRequest.Builder, ListGremlinQueriesRequest> {
    private static final SdkField<Boolean> INCLUDE_WAITING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeWaiting").getter(getter(ListGremlinQueriesRequest::includeWaiting))
            .setter(setter(Builder::includeWaiting))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeWaiting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_WAITING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean includeWaiting;

    private ListGremlinQueriesRequest(BuilderImpl builder) {
        super(builder);
        this.includeWaiting = builder.includeWaiting;
    }

    /**
     * <p>
     * If set to <code>TRUE</code>, the list returned includes waiting queries. The default is <code>FALSE</code>;
     * </p>
     * 
     * @return If set to <code>TRUE</code>, the list returned includes waiting queries. The default is
     *         <code>FALSE</code>;
     */
    public final Boolean includeWaiting() {
        return includeWaiting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeWaiting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGremlinQueriesRequest)) {
            return false;
        }
        ListGremlinQueriesRequest other = (ListGremlinQueriesRequest) obj;
        return Objects.equals(includeWaiting(), other.includeWaiting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGremlinQueriesRequest").add("IncludeWaiting", includeWaiting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeWaiting":
            return Optional.ofNullable(clazz.cast(includeWaiting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("includeWaiting", INCLUDE_WAITING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGremlinQueriesRequest, T> g) {
        return obj -> g.apply((ListGremlinQueriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGremlinQueriesRequest> {
        /**
         * <p>
         * If set to <code>TRUE</code>, the list returned includes waiting queries. The default is <code>FALSE</code>;
         * </p>
         * 
         * @param includeWaiting
         *        If set to <code>TRUE</code>, the list returned includes waiting queries. The default is
         *        <code>FALSE</code>;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWaiting(Boolean includeWaiting);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private Boolean includeWaiting;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGremlinQueriesRequest model) {
            super(model);
            includeWaiting(model.includeWaiting);
        }

        public final Boolean getIncludeWaiting() {
            return includeWaiting;
        }

        public final void setIncludeWaiting(Boolean includeWaiting) {
            this.includeWaiting = includeWaiting;
        }

        @Override
        public final Builder includeWaiting(Boolean includeWaiting) {
            this.includeWaiting = includeWaiting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGremlinQueriesRequest build() {
            return new ListGremlinQueriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
