/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteGremlinQueryResponse extends NeptunedataResponse implements
        ToCopyableBuilder<ExecuteGremlinQueryResponse.Builder, ExecuteGremlinQueryResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ExecuteGremlinQueryResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<GremlinQueryStatusAttributes> STATUS_FIELD = SdkField
            .<GremlinQueryStatusAttributes> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(ExecuteGremlinQueryResponse::status)).setter(setter(Builder::status))
            .constructor(GremlinQueryStatusAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Document> RESULT_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("result").getter(getter(ExecuteGremlinQueryResponse::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Document> META_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("meta")
            .getter(getter(ExecuteGremlinQueryResponse::meta)).setter(setter(Builder::meta))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meta").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            STATUS_FIELD, RESULT_FIELD, META_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final GremlinQueryStatusAttributes status;

    private final Document result;

    private final Document meta;

    private ExecuteGremlinQueryResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.status = builder.status;
        this.result = builder.result;
        this.meta = builder.meta;
    }

    /**
     * <p>
     * The unique identifier of the Gremlin query.
     * </p>
     * 
     * @return The unique identifier of the Gremlin query.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The status of the Gremlin query.
     * </p>
     * 
     * @return The status of the Gremlin query.
     */
    public final GremlinQueryStatusAttributes status() {
        return status;
    }

    /**
     * <p>
     * The Gremlin query output from the server.
     * </p>
     * 
     * @return The Gremlin query output from the server.
     */
    public final Document result() {
        return result;
    }

    /**
     * <p>
     * Metadata about the Gremlin query.
     * </p>
     * 
     * @return Metadata about the Gremlin query.
     */
    public final Document meta() {
        return meta;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(meta());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinQueryResponse)) {
            return false;
        }
        ExecuteGremlinQueryResponse other = (ExecuteGremlinQueryResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status())
                && Objects.equals(result(), other.result()) && Objects.equals(meta(), other.meta());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteGremlinQueryResponse").add("RequestId", requestId()).add("Status", status())
                .add("Result", result()).add("Meta", meta()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "meta":
            return Optional.ofNullable(clazz.cast(meta()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("meta", META_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinQueryResponse, T> g) {
        return obj -> g.apply((ExecuteGremlinQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteGremlinQueryResponse> {
        /**
         * <p>
         * The unique identifier of the Gremlin query.
         * </p>
         * 
         * @param requestIdValue
         *        The unique identifier of the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The status of the Gremlin query.
         * </p>
         * 
         * @param status
         *        The status of the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(GremlinQueryStatusAttributes status);

        /**
         * <p>
         * The status of the Gremlin query.
         * </p>
         * This is a convenience method that creates an instance of the {@link GremlinQueryStatusAttributes.Builder}
         * avoiding the need to create one manually via {@link GremlinQueryStatusAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GremlinQueryStatusAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #status(GremlinQueryStatusAttributes)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link GremlinQueryStatusAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(GremlinQueryStatusAttributes)
         */
        default Builder status(Consumer<GremlinQueryStatusAttributes.Builder> status) {
            return status(GremlinQueryStatusAttributes.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The Gremlin query output from the server.
         * </p>
         * 
         * @param result
         *        The Gremlin query output from the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Document result);

        /**
         * <p>
         * Metadata about the Gremlin query.
         * </p>
         * 
         * @param meta
         *        Metadata about the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meta(Document meta);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private GremlinQueryStatusAttributes status;

        private Document result;

        private Document meta;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinQueryResponse model) {
            super(model);
            requestId(model.requestIdValue);
            status(model.status);
            result(model.result);
            meta(model.meta);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final GremlinQueryStatusAttributes.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(GremlinQueryStatusAttributes.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(GremlinQueryStatusAttributes status) {
            this.status = status;
            return this;
        }

        public final Document getResult() {
            return result;
        }

        public final void setResult(Document result) {
            this.result = result;
        }

        @Override
        public final Builder result(Document result) {
            this.result = result;
            return this;
        }

        public final Document getMeta() {
            return meta;
        }

        public final void setMeta(Document meta) {
            this.meta = meta;
        }

        @Override
        public final Builder meta(Document meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public ExecuteGremlinQueryResponse build() {
            return new ExecuteGremlinQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
