/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteFastResetRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteFastResetRequest.Builder, ExecuteFastResetRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ExecuteFastResetRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(ExecuteFastResetRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final String token;

    private ExecuteFastResetRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.token = builder.token;
    }

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The fast reset action. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *         perform the fast reset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *         <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *         </p>
     *         <p/></li>
     * @see Action
     */
    public final Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The fast reset action. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *         perform the fast reset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *         <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *         </p>
     *         <p/></li>
     * @see Action
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The fast-reset token to initiate the reset.
     * </p>
     * 
     * @return The fast-reset token to initiate the reset.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteFastResetRequest)) {
            return false;
        }
        ExecuteFastResetRequest other = (ExecuteFastResetRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteFastResetRequest").add("Action", actionAsString()).add("Token", token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("token", TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteFastResetRequest, T> g) {
        return obj -> g.apply((ExecuteFastResetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteFastResetRequest> {
        /**
         * <p>
         * The fast reset action. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
         * perform the fast reset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
         * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
         * </p>
         * <p/></li>
         * </ul>
         * 
         * @param action
         *        The fast reset action. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to
         *        actually perform the fast reset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
         *        <code>initiateDatabaseReset</code> action to actually perform the fast reset.
         *        </p>
         *        <p/></li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The fast reset action. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
         * perform the fast reset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
         * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
         * </p>
         * <p/></li>
         * </ul>
         * 
         * @param action
         *        The fast reset action. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to
         *        actually perform the fast reset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
         *        <code>initiateDatabaseReset</code> action to actually perform the fast reset.
         *        </p>
         *        <p/></li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The fast-reset token to initiate the reset.
         * </p>
         * 
         * @param token
         *        The fast-reset token to initiate the reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String action;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteFastResetRequest model) {
            super(model);
            action(model.action);
            token(model.token);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteFastResetRequest build() {
            return new ExecuteFastResetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
