/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMlEndpointRequest extends NeptunedataRequest implements
        ToCopyableBuilder<CreateMlEndpointRequest.Builder, CreateMlEndpointRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateMlEndpointRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ML_MODEL_TRAINING_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlModelTrainingJobId").getter(getter(CreateMlEndpointRequest::mlModelTrainingJobId))
            .setter(setter(Builder::mlModelTrainingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTrainingJobId").build())
            .build();

    private static final SdkField<String> ML_MODEL_TRANSFORM_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlModelTransformJobId").getter(getter(CreateMlEndpointRequest::mlModelTransformJobId))
            .setter(setter(Builder::mlModelTransformJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTransformJobId").build())
            .build();

    private static final SdkField<Boolean> UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("update").getter(getter(CreateMlEndpointRequest::update)).setter(setter(Builder::update))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("update").build()).build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(CreateMlEndpointRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(CreateMlEndpointRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(CreateMlEndpointRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("instanceCount").getter(getter(CreateMlEndpointRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeEncryptionKMSKey").getter(getter(CreateMlEndpointRequest::volumeEncryptionKMSKey))
            .setter(setter(Builder::volumeEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            ML_MODEL_TRAINING_JOB_ID_FIELD, ML_MODEL_TRANSFORM_JOB_ID_FIELD, UPDATE_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD,
            MODEL_NAME_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String mlModelTrainingJobId;

    private final String mlModelTransformJobId;

    private final Boolean update;

    private final String neptuneIamRoleArn;

    private final String modelName;

    private final String instanceType;

    private final Integer instanceCount;

    private final String volumeEncryptionKMSKey;

    private CreateMlEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.mlModelTrainingJobId = builder.mlModelTrainingJobId;
        this.mlModelTransformJobId = builder.mlModelTransformJobId;
        this.update = builder.update;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.modelName = builder.modelName;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
     * </p>
     * 
     * @return A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job Id of the completed model-training job that has created the model that the inference endpoint will point
     * to. You must supply either the <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.
     * </p>
     * 
     * @return The job Id of the completed model-training job that has created the model that the inference endpoint
     *         will point to. You must supply either the <code>mlModelTrainingJobId</code> or the
     *         <code>mlModelTransformJobId</code>.
     */
    public final String mlModelTrainingJobId() {
        return mlModelTrainingJobId;
    }

    /**
     * <p>
     * The job Id of the completed model-transform job. You must supply either the <code>mlModelTrainingJobId</code> or
     * the <code>mlModelTransformJobId</code>.
     * </p>
     * 
     * @return The job Id of the completed model-transform job. You must supply either the
     *         <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.
     */
    public final String mlModelTransformJobId() {
        return mlModelTransformJobId;
    }

    /**
     * <p>
     * If set to <code>true</code>, <code>update</code> indicates that this is an update request. The default is
     * <code>false</code>. You must supply either the <code>mlModelTrainingJobId</code> or the
     * <code>mlModelTransformJobId</code>.
     * </p>
     * 
     * @return If set to <code>true</code>, <code>update</code> indicates that this is an update request. The default is
     *         <code>false</code>. You must supply either the <code>mlModelTrainingJobId</code> or the
     *         <code>mlModelTransformJobId</code>.
     */
    public final Boolean update() {
        return update;
    }

    /**
     * <p>
     * The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in your
     * DB cluster parameter group or an error will be thrown.
     * </p>
     * 
     * @return The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed
     *         in your DB cluster parameter group or an error will be thrown.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    /**
     * <p>
     * Model type for training. By default the Neptune ML model is automatically based on the <code>modelType</code>
     * used in data processing, but you can specify a different model type here. The default is <code>rgcn</code> for
     * heterogeneous graphs and <code>kge</code> for knowledge graphs. The only valid value for heterogeneous graphs is
     * <code>rgcn</code>. Valid values for knowledge graphs are: <code>kge</code>, <code>transe</code>,
     * <code>distmult</code>, and <code>rotate</code>.
     * </p>
     * 
     * @return Model type for training. By default the Neptune ML model is automatically based on the
     *         <code>modelType</code> used in data processing, but you can specify a different model type here. The
     *         default is <code>rgcn</code> for heterogeneous graphs and <code>kge</code> for knowledge graphs. The only
     *         valid value for heterogeneous graphs is <code>rgcn</code>. Valid values for knowledge graphs are:
     *         <code>kge</code>, <code>transe</code>, <code>distmult</code>, and <code>rotate</code>.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The type of Neptune ML instance to use for online servicing. The default is <code>ml.m5.xlarge</code>. Choosing
     * the ML instance for an inference endpoint depends on the task type, the graph size, and your budget.
     * </p>
     * 
     * @return The type of Neptune ML instance to use for online servicing. The default is <code>ml.m5.xlarge</code>.
     *         Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your
     *         budget.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
     * </p>
     * 
     * @return The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
     * attached to the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
     *         volume attached to the ML compute instances that run the training job. The default is None.
     */
    public final String volumeEncryptionKMSKey() {
        return volumeEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTransformJobId());
        hashCode = 31 * hashCode + Objects.hashCode(update());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKMSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlEndpointRequest)) {
            return false;
        }
        CreateMlEndpointRequest other = (CreateMlEndpointRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(mlModelTrainingJobId(), other.mlModelTrainingJobId())
                && Objects.equals(mlModelTransformJobId(), other.mlModelTransformJobId())
                && Objects.equals(update(), other.update()) && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMlEndpointRequest").add("Id", id()).add("MlModelTrainingJobId", mlModelTrainingJobId())
                .add("MlModelTransformJobId", mlModelTransformJobId()).add("Update", update())
                .add("NeptuneIamRoleArn", neptuneIamRoleArn()).add("ModelName", modelName()).add("InstanceType", instanceType())
                .add("InstanceCount", instanceCount()).add("VolumeEncryptionKMSKey", volumeEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "mlModelTrainingJobId":
            return Optional.ofNullable(clazz.cast(mlModelTrainingJobId()));
        case "mlModelTransformJobId":
            return Optional.ofNullable(clazz.cast(mlModelTransformJobId()));
        case "update":
            return Optional.ofNullable(clazz.cast(update()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "instanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "volumeEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKMSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("mlModelTrainingJobId", ML_MODEL_TRAINING_JOB_ID_FIELD);
        map.put("mlModelTransformJobId", ML_MODEL_TRANSFORM_JOB_ID_FIELD);
        map.put("update", UPDATE_FIELD);
        map.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("instanceCount", INSTANCE_COUNT_FIELD);
        map.put("volumeEncryptionKMSKey", VOLUME_ENCRYPTION_KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMlEndpointRequest, T> g) {
        return obj -> g.apply((CreateMlEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMlEndpointRequest> {
        /**
         * <p>
         * A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
         * </p>
         * 
         * @param id
         *        A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job Id of the completed model-training job that has created the model that the inference endpoint will
         * point to. You must supply either the <code>mlModelTrainingJobId</code> or the
         * <code>mlModelTransformJobId</code>.
         * </p>
         * 
         * @param mlModelTrainingJobId
         *        The job Id of the completed model-training job that has created the model that the inference endpoint
         *        will point to. You must supply either the <code>mlModelTrainingJobId</code> or the
         *        <code>mlModelTransformJobId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelTrainingJobId(String mlModelTrainingJobId);

        /**
         * <p>
         * The job Id of the completed model-transform job. You must supply either the <code>mlModelTrainingJobId</code>
         * or the <code>mlModelTransformJobId</code>.
         * </p>
         * 
         * @param mlModelTransformJobId
         *        The job Id of the completed model-transform job. You must supply either the
         *        <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelTransformJobId(String mlModelTransformJobId);

        /**
         * <p>
         * If set to <code>true</code>, <code>update</code> indicates that this is an update request. The default is
         * <code>false</code>. You must supply either the <code>mlModelTrainingJobId</code> or the
         * <code>mlModelTransformJobId</code>.
         * </p>
         * 
         * @param update
         *        If set to <code>true</code>, <code>update</code> indicates that this is an update request. The default
         *        is <code>false</code>. You must supply either the <code>mlModelTrainingJobId</code> or the
         *        <code>mlModelTransformJobId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(Boolean update);

        /**
         * <p>
         * The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in
         * your DB cluster parameter group or an error will be thrown.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be
         *        listed in your DB cluster parameter group or an error will be thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        /**
         * <p>
         * Model type for training. By default the Neptune ML model is automatically based on the <code>modelType</code>
         * used in data processing, but you can specify a different model type here. The default is <code>rgcn</code>
         * for heterogeneous graphs and <code>kge</code> for knowledge graphs. The only valid value for heterogeneous
         * graphs is <code>rgcn</code>. Valid values for knowledge graphs are: <code>kge</code>, <code>transe</code>,
         * <code>distmult</code>, and <code>rotate</code>.
         * </p>
         * 
         * @param modelName
         *        Model type for training. By default the Neptune ML model is automatically based on the
         *        <code>modelType</code> used in data processing, but you can specify a different model type here. The
         *        default is <code>rgcn</code> for heterogeneous graphs and <code>kge</code> for knowledge graphs. The
         *        only valid value for heterogeneous graphs is <code>rgcn</code>. Valid values for knowledge graphs are:
         *        <code>kge</code>, <code>transe</code>, <code>distmult</code>, and <code>rotate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The type of Neptune ML instance to use for online servicing. The default is <code>ml.m5.xlarge</code>.
         * Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your budget.
         * </p>
         * 
         * @param instanceType
         *        The type of Neptune ML instance to use for online servicing. The default is <code>ml.m5.xlarge</code>.
         *        Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your
         *        budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
         * </p>
         * 
         * @param instanceCount
         *        The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instances that run the training job. The default is None.
         * </p>
         * 
         * @param volumeEncryptionKMSKey
         *        The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage
         *        volume attached to the ML compute instances that run the training job. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String id;

        private String mlModelTrainingJobId;

        private String mlModelTransformJobId;

        private Boolean update;

        private String neptuneIamRoleArn;

        private String modelName;

        private String instanceType;

        private Integer instanceCount;

        private String volumeEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlEndpointRequest model) {
            super(model);
            id(model.id);
            mlModelTrainingJobId(model.mlModelTrainingJobId);
            mlModelTransformJobId(model.mlModelTransformJobId);
            update(model.update);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
            modelName(model.modelName);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMlModelTrainingJobId() {
            return mlModelTrainingJobId;
        }

        public final void setMlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
        }

        @Override
        public final Builder mlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
            return this;
        }

        public final String getMlModelTransformJobId() {
            return mlModelTransformJobId;
        }

        public final void setMlModelTransformJobId(String mlModelTransformJobId) {
            this.mlModelTransformJobId = mlModelTransformJobId;
        }

        @Override
        public final Builder mlModelTransformJobId(String mlModelTransformJobId) {
            this.mlModelTransformJobId = mlModelTransformJobId;
            return this;
        }

        public final Boolean getUpdate() {
            return update;
        }

        public final void setUpdate(Boolean update) {
            this.update = update;
        }

        @Override
        public final Builder update(Boolean update) {
            this.update = update;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlEndpointRequest build() {
            return new CreateMlEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
