/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteGremlinProfileQueryRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, ExecuteGremlinProfileQueryRequest> {
    private static final SdkField<String> GREMLIN_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gremlinQuery").getter(ExecuteGremlinProfileQueryRequest.getter(ExecuteGremlinProfileQueryRequest::gremlinQuery)).setter(ExecuteGremlinProfileQueryRequest.setter(Builder::gremlinQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()}).build();
    private static final SdkField<Boolean> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("results").getter(ExecuteGremlinProfileQueryRequest.getter(ExecuteGremlinProfileQueryRequest::results)).setter(ExecuteGremlinProfileQueryRequest.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.results").build()}).build();
    private static final SdkField<Integer> CHOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("chop").getter(ExecuteGremlinProfileQueryRequest.getter(ExecuteGremlinProfileQueryRequest::chop)).setter(ExecuteGremlinProfileQueryRequest.setter(Builder::chop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.chop").build()}).build();
    private static final SdkField<String> SERIALIZER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serializer").getter(ExecuteGremlinProfileQueryRequest.getter(ExecuteGremlinProfileQueryRequest::serializer)).setter(ExecuteGremlinProfileQueryRequest.setter(Builder::serializer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.serializer").build()}).build();
    private static final SdkField<Boolean> INDEX_OPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("indexOps").getter(ExecuteGremlinProfileQueryRequest.getter(ExecuteGremlinProfileQueryRequest::indexOps)).setter(ExecuteGremlinProfileQueryRequest.setter(Builder::indexOps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.indexOps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREMLIN_QUERY_FIELD, RESULTS_FIELD, CHOP_FIELD, SERIALIZER_FIELD, INDEX_OPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteGremlinProfileQueryRequest.memberNameToFieldInitializer();
    private final String gremlinQuery;
    private final Boolean results;
    private final Integer chop;
    private final String serializer;
    private final Boolean indexOps;

    private ExecuteGremlinProfileQueryRequest(BuilderImpl builder) {
        super(builder);
        this.gremlinQuery = builder.gremlinQuery;
        this.results = builder.results;
        this.chop = builder.chop;
        this.serializer = builder.serializer;
        this.indexOps = builder.indexOps;
    }

    public final String gremlinQuery() {
        return this.gremlinQuery;
    }

    public final Boolean results() {
        return this.results;
    }

    public final Integer chop() {
        return this.chop;
    }

    public final String serializer() {
        return this.serializer;
    }

    public final Boolean indexOps() {
        return this.indexOps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gremlinQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.chop());
        hashCode = 31 * hashCode + Objects.hashCode(this.serializer());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexOps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinProfileQueryRequest)) {
            return false;
        }
        ExecuteGremlinProfileQueryRequest other = (ExecuteGremlinProfileQueryRequest)((Object)obj);
        return Objects.equals(this.gremlinQuery(), other.gremlinQuery()) && Objects.equals(this.results(), other.results()) && Objects.equals(this.chop(), other.chop()) && Objects.equals(this.serializer(), other.serializer()) && Objects.equals(this.indexOps(), other.indexOps());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteGremlinProfileQueryRequest").add("GremlinQuery", (Object)this.gremlinQuery()).add("Results", (Object)this.results()).add("Chop", (Object)this.chop()).add("Serializer", (Object)this.serializer()).add("IndexOps", (Object)this.indexOps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gremlinQuery": {
                return Optional.ofNullable(clazz.cast(this.gremlinQuery()));
            }
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "chop": {
                return Optional.ofNullable(clazz.cast(this.chop()));
            }
            case "serializer": {
                return Optional.ofNullable(clazz.cast(this.serializer()));
            }
            case "indexOps": {
                return Optional.ofNullable(clazz.cast(this.indexOps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gremlin", GREMLIN_QUERY_FIELD);
        map.put("profile.results", RESULTS_FIELD);
        map.put("profile.chop", CHOP_FIELD);
        map.put("profile.serializer", SERIALIZER_FIELD);
        map.put("profile.indexOps", INDEX_OPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinProfileQueryRequest, T> g) {
        return obj -> g.apply((ExecuteGremlinProfileQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String gremlinQuery;
        private Boolean results;
        private Integer chop;
        private String serializer;
        private Boolean indexOps;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinProfileQueryRequest model) {
            super(model);
            this.gremlinQuery(model.gremlinQuery);
            this.results(model.results);
            this.chop(model.chop);
            this.serializer(model.serializer);
            this.indexOps(model.indexOps);
        }

        public final String getGremlinQuery() {
            return this.gremlinQuery;
        }

        public final void setGremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
        }

        @Override
        public final Builder gremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
            return this;
        }

        public final Boolean getResults() {
            return this.results;
        }

        public final void setResults(Boolean results) {
            this.results = results;
        }

        @Override
        public final Builder results(Boolean results) {
            this.results = results;
            return this;
        }

        public final Integer getChop() {
            return this.chop;
        }

        public final void setChop(Integer chop) {
            this.chop = chop;
        }

        @Override
        public final Builder chop(Integer chop) {
            this.chop = chop;
            return this;
        }

        public final String getSerializer() {
            return this.serializer;
        }

        public final void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        @Override
        public final Builder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        public final Boolean getIndexOps() {
            return this.indexOps;
        }

        public final void setIndexOps(Boolean indexOps) {
            this.indexOps = indexOps;
        }

        @Override
        public final Builder indexOps(Boolean indexOps) {
            this.indexOps = indexOps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteGremlinProfileQueryRequest build() {
            return new ExecuteGremlinProfileQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteGremlinProfileQueryRequest> {
        public Builder gremlinQuery(String var1);

        public Builder results(Boolean var1);

        public Builder chop(Integer var1);

        public Builder serializer(String var1);

        public Builder indexOps(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

