/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunedata.model.DocumentValuedMapCopier;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.services.neptunedata.model.QueryLanguageVersion;
import software.amazon.awssdk.services.neptunedata.model.StringValuedMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEngineStatusResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetEngineStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::status)).setter(GetEngineStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startTime").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::startTime)).setter(GetEngineStatusResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbEngineVersion").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::dbEngineVersion)).setter(GetEngineStatusResponse.setter(Builder::dbEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbEngineVersion").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::role)).setter(GetEngineStatusResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<String> DFE_QUERY_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dfeQueryEngine").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::dfeQueryEngine)).setter(GetEngineStatusResponse.setter(Builder::dfeQueryEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dfeQueryEngine").build()}).build();
    private static final SdkField<QueryLanguageVersion> GREMLIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gremlin").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::gremlin)).setter(GetEngineStatusResponse.setter(Builder::gremlin)).constructor(QueryLanguageVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()}).build();
    private static final SdkField<QueryLanguageVersion> SPARQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparql").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::sparql)).setter(GetEngineStatusResponse.setter(Builder::sparql)).constructor(QueryLanguageVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparql").build()}).build();
    private static final SdkField<QueryLanguageVersion> OPENCYPHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("opencypher").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::opencypher)).setter(GetEngineStatusResponse.setter(Builder::opencypher)).constructor(QueryLanguageVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opencypher").build()}).build();
    private static final SdkField<Map<String, String>> LAB_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labMode").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::labMode)).setter(GetEngineStatusResponse.setter(Builder::labMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labMode").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> ROLLING_BACK_TRX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rollingBackTrxCount").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::rollingBackTrxCount)).setter(GetEngineStatusResponse.setter(Builder::rollingBackTrxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollingBackTrxCount").build()}).build();
    private static final SdkField<String> ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rollingBackTrxEarliestStartTime").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::rollingBackTrxEarliestStartTime)).setter(GetEngineStatusResponse.setter(Builder::rollingBackTrxEarliestStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollingBackTrxEarliestStartTime").build()}).build();
    private static final SdkField<Map<String, Document>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("features").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::features)).setter(GetEngineStatusResponse.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("settings").getter(GetEngineStatusResponse.getter(GetEngineStatusResponse::settings)).setter(GetEngineStatusResponse.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, START_TIME_FIELD, DB_ENGINE_VERSION_FIELD, ROLE_FIELD, DFE_QUERY_ENGINE_FIELD, GREMLIN_FIELD, SPARQL_FIELD, OPENCYPHER_FIELD, LAB_MODE_FIELD, ROLLING_BACK_TRX_COUNT_FIELD, ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD, FEATURES_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEngineStatusResponse.memberNameToFieldInitializer();
    private final String status;
    private final String startTime;
    private final String dbEngineVersion;
    private final String role;
    private final String dfeQueryEngine;
    private final QueryLanguageVersion gremlin;
    private final QueryLanguageVersion sparql;
    private final QueryLanguageVersion opencypher;
    private final Map<String, String> labMode;
    private final Integer rollingBackTrxCount;
    private final String rollingBackTrxEarliestStartTime;
    private final Map<String, Document> features;
    private final Map<String, String> settings;

    private GetEngineStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.dbEngineVersion = builder.dbEngineVersion;
        this.role = builder.role;
        this.dfeQueryEngine = builder.dfeQueryEngine;
        this.gremlin = builder.gremlin;
        this.sparql = builder.sparql;
        this.opencypher = builder.opencypher;
        this.labMode = builder.labMode;
        this.rollingBackTrxCount = builder.rollingBackTrxCount;
        this.rollingBackTrxEarliestStartTime = builder.rollingBackTrxEarliestStartTime;
        this.features = builder.features;
        this.settings = builder.settings;
    }

    public final String status() {
        return this.status;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String dbEngineVersion() {
        return this.dbEngineVersion;
    }

    public final String role() {
        return this.role;
    }

    public final String dfeQueryEngine() {
        return this.dfeQueryEngine;
    }

    public final QueryLanguageVersion gremlin() {
        return this.gremlin;
    }

    public final QueryLanguageVersion sparql() {
        return this.sparql;
    }

    public final QueryLanguageVersion opencypher() {
        return this.opencypher;
    }

    public final boolean hasLabMode() {
        return this.labMode != null && !(this.labMode instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labMode() {
        return this.labMode;
    }

    public final Integer rollingBackTrxCount() {
        return this.rollingBackTrxCount;
    }

    public final String rollingBackTrxEarliestStartTime() {
        return this.rollingBackTrxEarliestStartTime;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> features() {
        return this.features;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.dfeQueryEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.gremlin());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparql());
        hashCode = 31 * hashCode + Objects.hashCode(this.opencypher());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabMode() ? this.labMode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingBackTrxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingBackTrxEarliestStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngineStatusResponse)) {
            return false;
        }
        GetEngineStatusResponse other = (GetEngineStatusResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.dbEngineVersion(), other.dbEngineVersion()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.dfeQueryEngine(), other.dfeQueryEngine()) && Objects.equals(this.gremlin(), other.gremlin()) && Objects.equals(this.sparql(), other.sparql()) && Objects.equals(this.opencypher(), other.opencypher()) && this.hasLabMode() == other.hasLabMode() && Objects.equals(this.labMode(), other.labMode()) && Objects.equals(this.rollingBackTrxCount(), other.rollingBackTrxCount()) && Objects.equals(this.rollingBackTrxEarliestStartTime(), other.rollingBackTrxEarliestStartTime()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"GetEngineStatusResponse").add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("DbEngineVersion", (Object)this.dbEngineVersion()).add("Role", (Object)this.role()).add("DfeQueryEngine", (Object)this.dfeQueryEngine()).add("Gremlin", (Object)this.gremlin()).add("Sparql", (Object)this.sparql()).add("Opencypher", (Object)this.opencypher()).add("LabMode", this.hasLabMode() ? this.labMode() : null).add("RollingBackTrxCount", (Object)this.rollingBackTrxCount()).add("RollingBackTrxEarliestStartTime", (Object)this.rollingBackTrxEarliestStartTime()).add("Features", this.hasFeatures() ? this.features() : null).add("Settings", this.hasSettings() ? this.settings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "dbEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersion()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "dfeQueryEngine": {
                return Optional.ofNullable(clazz.cast(this.dfeQueryEngine()));
            }
            case "gremlin": {
                return Optional.ofNullable(clazz.cast(this.gremlin()));
            }
            case "sparql": {
                return Optional.ofNullable(clazz.cast(this.sparql()));
            }
            case "opencypher": {
                return Optional.ofNullable(clazz.cast(this.opencypher()));
            }
            case "labMode": {
                return Optional.ofNullable(clazz.cast(this.labMode()));
            }
            case "rollingBackTrxCount": {
                return Optional.ofNullable(clazz.cast(this.rollingBackTrxCount()));
            }
            case "rollingBackTrxEarliestStartTime": {
                return Optional.ofNullable(clazz.cast(this.rollingBackTrxEarliestStartTime()));
            }
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("dbEngineVersion", DB_ENGINE_VERSION_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("dfeQueryEngine", DFE_QUERY_ENGINE_FIELD);
        map.put("gremlin", GREMLIN_FIELD);
        map.put("sparql", SPARQL_FIELD);
        map.put("opencypher", OPENCYPHER_FIELD);
        map.put("labMode", LAB_MODE_FIELD);
        map.put("rollingBackTrxCount", ROLLING_BACK_TRX_COUNT_FIELD);
        map.put("rollingBackTrxEarliestStartTime", ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEngineStatusResponse, T> g) {
        return obj -> g.apply((GetEngineStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String status;
        private String startTime;
        private String dbEngineVersion;
        private String role;
        private String dfeQueryEngine;
        private QueryLanguageVersion gremlin;
        private QueryLanguageVersion sparql;
        private QueryLanguageVersion opencypher;
        private Map<String, String> labMode = DefaultSdkAutoConstructMap.getInstance();
        private Integer rollingBackTrxCount;
        private String rollingBackTrxEarliestStartTime;
        private Map<String, Document> features = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> settings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngineStatusResponse model) {
            super(model);
            this.status(model.status);
            this.startTime(model.startTime);
            this.dbEngineVersion(model.dbEngineVersion);
            this.role(model.role);
            this.dfeQueryEngine(model.dfeQueryEngine);
            this.gremlin(model.gremlin);
            this.sparql(model.sparql);
            this.opencypher(model.opencypher);
            this.labMode(model.labMode);
            this.rollingBackTrxCount(model.rollingBackTrxCount);
            this.rollingBackTrxEarliestStartTime(model.rollingBackTrxEarliestStartTime);
            this.features(model.features);
            this.settings(model.settings);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDbEngineVersion() {
            return this.dbEngineVersion;
        }

        public final void setDbEngineVersion(String dbEngineVersion) {
            this.dbEngineVersion = dbEngineVersion;
        }

        @Override
        public final Builder dbEngineVersion(String dbEngineVersion) {
            this.dbEngineVersion = dbEngineVersion;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getDfeQueryEngine() {
            return this.dfeQueryEngine;
        }

        public final void setDfeQueryEngine(String dfeQueryEngine) {
            this.dfeQueryEngine = dfeQueryEngine;
        }

        @Override
        public final Builder dfeQueryEngine(String dfeQueryEngine) {
            this.dfeQueryEngine = dfeQueryEngine;
            return this;
        }

        public final QueryLanguageVersion.Builder getGremlin() {
            return this.gremlin != null ? this.gremlin.toBuilder() : null;
        }

        public final void setGremlin(QueryLanguageVersion.BuilderImpl gremlin) {
            this.gremlin = gremlin != null ? gremlin.build() : null;
        }

        @Override
        public final Builder gremlin(QueryLanguageVersion gremlin) {
            this.gremlin = gremlin;
            return this;
        }

        public final QueryLanguageVersion.Builder getSparql() {
            return this.sparql != null ? this.sparql.toBuilder() : null;
        }

        public final void setSparql(QueryLanguageVersion.BuilderImpl sparql) {
            this.sparql = sparql != null ? sparql.build() : null;
        }

        @Override
        public final Builder sparql(QueryLanguageVersion sparql) {
            this.sparql = sparql;
            return this;
        }

        public final QueryLanguageVersion.Builder getOpencypher() {
            return this.opencypher != null ? this.opencypher.toBuilder() : null;
        }

        public final void setOpencypher(QueryLanguageVersion.BuilderImpl opencypher) {
            this.opencypher = opencypher != null ? opencypher.build() : null;
        }

        @Override
        public final Builder opencypher(QueryLanguageVersion opencypher) {
            this.opencypher = opencypher;
            return this;
        }

        public final Map<String, String> getLabMode() {
            if (this.labMode instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labMode;
        }

        public final void setLabMode(Map<String, String> labMode) {
            this.labMode = StringValuedMapCopier.copy(labMode);
        }

        @Override
        public final Builder labMode(Map<String, String> labMode) {
            this.labMode = StringValuedMapCopier.copy(labMode);
            return this;
        }

        public final Integer getRollingBackTrxCount() {
            return this.rollingBackTrxCount;
        }

        public final void setRollingBackTrxCount(Integer rollingBackTrxCount) {
            this.rollingBackTrxCount = rollingBackTrxCount;
        }

        @Override
        public final Builder rollingBackTrxCount(Integer rollingBackTrxCount) {
            this.rollingBackTrxCount = rollingBackTrxCount;
            return this;
        }

        public final String getRollingBackTrxEarliestStartTime() {
            return this.rollingBackTrxEarliestStartTime;
        }

        public final void setRollingBackTrxEarliestStartTime(String rollingBackTrxEarliestStartTime) {
            this.rollingBackTrxEarliestStartTime = rollingBackTrxEarliestStartTime;
        }

        @Override
        public final Builder rollingBackTrxEarliestStartTime(String rollingBackTrxEarliestStartTime) {
            this.rollingBackTrxEarliestStartTime = rollingBackTrxEarliestStartTime;
            return this;
        }

        public final Map<String, Document> getFeatures() {
            if (this.features instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.features;
        }

        public final void setFeatures(Map<String, Document> features) {
            this.features = DocumentValuedMapCopier.copy(features);
        }

        @Override
        public final Builder features(Map<String, Document> features) {
            this.features = DocumentValuedMapCopier.copy(features);
            return this;
        }

        public final Map<String, String> getSettings() {
            if (this.settings instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.settings;
        }

        public final void setSettings(Map<String, String> settings) {
            this.settings = StringValuedMapCopier.copy(settings);
        }

        @Override
        @Transient
        public final Builder settings(Map<String, String> settings) {
            this.settings = StringValuedMapCopier.copy(settings);
            return this;
        }

        @Override
        public GetEngineStatusResponse build() {
            return new GetEngineStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEngineStatusResponse> {
        public Builder status(String var1);

        public Builder startTime(String var1);

        public Builder dbEngineVersion(String var1);

        public Builder role(String var1);

        public Builder dfeQueryEngine(String var1);

        public Builder gremlin(QueryLanguageVersion var1);

        default public Builder gremlin(Consumer<QueryLanguageVersion.Builder> gremlin) {
            return this.gremlin((QueryLanguageVersion)((QueryLanguageVersion.Builder)QueryLanguageVersion.builder().applyMutation(gremlin)).build());
        }

        public Builder sparql(QueryLanguageVersion var1);

        default public Builder sparql(Consumer<QueryLanguageVersion.Builder> sparql) {
            return this.sparql((QueryLanguageVersion)((QueryLanguageVersion.Builder)QueryLanguageVersion.builder().applyMutation(sparql)).build());
        }

        public Builder opencypher(QueryLanguageVersion var1);

        default public Builder opencypher(Consumer<QueryLanguageVersion.Builder> opencypher) {
            return this.opencypher((QueryLanguageVersion)((QueryLanguageVersion.Builder)QueryLanguageVersion.builder().applyMutation(opencypher)).build());
        }

        public Builder labMode(Map<String, String> var1);

        public Builder rollingBackTrxCount(Integer var1);

        public Builder rollingBackTrxEarliestStartTime(String var1);

        public Builder features(Map<String, Document> var1);

        public Builder settings(Map<String, String> var1);
    }
}

