/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.CustomModelTransformParameters;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.services.neptunedata.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMlModelTransformJobRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, StartMlModelTransformJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::id)).setter(StartMlModelTransformJobRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DATA_PROCESSING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProcessingJobId").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::dataProcessingJobId)).setter(StartMlModelTransformJobRequest.setter(Builder::dataProcessingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingJobId").build()}).build();
    private static final SdkField<String> ML_MODEL_TRAINING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlModelTrainingJobId").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::mlModelTrainingJobId)).setter(StartMlModelTransformJobRequest.setter(Builder::mlModelTrainingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTrainingJobId").build()}).build();
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingJobName").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::trainingJobName)).setter(StartMlModelTransformJobRequest.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingJobName").build()}).build();
    private static final SdkField<String> MODEL_TRANSFORM_OUTPUT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelTransformOutputS3Location").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::modelTransformOutputS3Location)).setter(StartMlModelTransformJobRequest.setter(Builder::modelTransformOutputS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTransformOutputS3Location").build()}).build();
    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sagemakerIamRoleArn").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::sagemakerIamRoleArn)).setter(StartMlModelTransformJobRequest.setter(Builder::sagemakerIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::neptuneIamRoleArn)).setter(StartMlModelTransformJobRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()}).build();
    private static final SdkField<CustomModelTransformParameters> CUSTOM_MODEL_TRANSFORM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customModelTransformParameters").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::customModelTransformParameters)).setter(StartMlModelTransformJobRequest.setter(Builder::customModelTransformParameters)).constructor(CustomModelTransformParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTransformParameters").build()}).build();
    private static final SdkField<String> BASE_PROCESSING_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseProcessingInstanceType").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::baseProcessingInstanceType)).setter(StartMlModelTransformJobRequest.setter(Builder::baseProcessingInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingInstanceType").build()}).build();
    private static final SdkField<Integer> BASE_PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseProcessingInstanceVolumeSizeInGB").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::baseProcessingInstanceVolumeSizeInGB)).setter(StartMlModelTransformJobRequest.setter(Builder::baseProcessingInstanceVolumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingInstanceVolumeSizeInGB").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::subnets)).setter(StartMlModelTransformJobRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::securityGroupIds)).setter(StartMlModelTransformJobRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeEncryptionKMSKey").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::volumeEncryptionKMSKey)).setter(StartMlModelTransformJobRequest.setter(Builder::volumeEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build()}).build();
    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3OutputEncryptionKMSKey").getter(StartMlModelTransformJobRequest.getter(StartMlModelTransformJobRequest::s3OutputEncryptionKMSKey)).setter(StartMlModelTransformJobRequest.setter(Builder::s3OutputEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_PROCESSING_JOB_ID_FIELD, ML_MODEL_TRAINING_JOB_ID_FIELD, TRAINING_JOB_NAME_FIELD, MODEL_TRANSFORM_OUTPUT_S3_LOCATION_FIELD, SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, CUSTOM_MODEL_TRANSFORM_PARAMETERS_FIELD, BASE_PROCESSING_INSTANCE_TYPE_FIELD, BASE_PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD, S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMlModelTransformJobRequest.memberNameToFieldInitializer();
    private final String id;
    private final String dataProcessingJobId;
    private final String mlModelTrainingJobId;
    private final String trainingJobName;
    private final String modelTransformOutputS3Location;
    private final String sagemakerIamRoleArn;
    private final String neptuneIamRoleArn;
    private final CustomModelTransformParameters customModelTransformParameters;
    private final String baseProcessingInstanceType;
    private final Integer baseProcessingInstanceVolumeSizeInGB;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String volumeEncryptionKMSKey;
    private final String s3OutputEncryptionKMSKey;

    private StartMlModelTransformJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.dataProcessingJobId = builder.dataProcessingJobId;
        this.mlModelTrainingJobId = builder.mlModelTrainingJobId;
        this.trainingJobName = builder.trainingJobName;
        this.modelTransformOutputS3Location = builder.modelTransformOutputS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.customModelTransformParameters = builder.customModelTransformParameters;
        this.baseProcessingInstanceType = builder.baseProcessingInstanceType;
        this.baseProcessingInstanceVolumeSizeInGB = builder.baseProcessingInstanceVolumeSizeInGB;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
    }

    public final String id() {
        return this.id;
    }

    public final String dataProcessingJobId() {
        return this.dataProcessingJobId;
    }

    public final String mlModelTrainingJobId() {
        return this.mlModelTrainingJobId;
    }

    public final String trainingJobName() {
        return this.trainingJobName;
    }

    public final String modelTransformOutputS3Location() {
        return this.modelTransformOutputS3Location;
    }

    public final String sagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    public final CustomModelTransformParameters customModelTransformParameters() {
        return this.customModelTransformParameters;
    }

    public final String baseProcessingInstanceType() {
        return this.baseProcessingInstanceType;
    }

    public final Integer baseProcessingInstanceVolumeSizeInGB() {
        return this.baseProcessingInstanceVolumeSizeInGB;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String volumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    public final String s3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTransformOutputS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelTransformParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseProcessingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseProcessingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputEncryptionKMSKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlModelTransformJobRequest)) {
            return false;
        }
        StartMlModelTransformJobRequest other = (StartMlModelTransformJobRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.dataProcessingJobId(), other.dataProcessingJobId()) && Objects.equals(this.mlModelTrainingJobId(), other.mlModelTrainingJobId()) && Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.modelTransformOutputS3Location(), other.modelTransformOutputS3Location()) && Objects.equals(this.sagemakerIamRoleArn(), other.sagemakerIamRoleArn()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn()) && Objects.equals(this.customModelTransformParameters(), other.customModelTransformParameters()) && Objects.equals(this.baseProcessingInstanceType(), other.baseProcessingInstanceType()) && Objects.equals(this.baseProcessingInstanceVolumeSizeInGB(), other.baseProcessingInstanceVolumeSizeInGB()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey()) && Objects.equals(this.s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey());
    }

    public final String toString() {
        return ToString.builder((String)"StartMlModelTransformJobRequest").add("Id", (Object)this.id()).add("DataProcessingJobId", (Object)this.dataProcessingJobId()).add("MlModelTrainingJobId", (Object)this.mlModelTrainingJobId()).add("TrainingJobName", (Object)this.trainingJobName()).add("ModelTransformOutputS3Location", (Object)this.modelTransformOutputS3Location()).add("SagemakerIamRoleArn", (Object)this.sagemakerIamRoleArn()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).add("CustomModelTransformParameters", (Object)this.customModelTransformParameters()).add("BaseProcessingInstanceType", (Object)this.baseProcessingInstanceType()).add("BaseProcessingInstanceVolumeSizeInGB", (Object)this.baseProcessingInstanceVolumeSizeInGB()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("VolumeEncryptionKMSKey", (Object)this.volumeEncryptionKMSKey()).add("S3OutputEncryptionKMSKey", (Object)this.s3OutputEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "dataProcessingJobId": {
                return Optional.ofNullable(clazz.cast(this.dataProcessingJobId()));
            }
            case "mlModelTrainingJobId": {
                return Optional.ofNullable(clazz.cast(this.mlModelTrainingJobId()));
            }
            case "trainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "modelTransformOutputS3Location": {
                return Optional.ofNullable(clazz.cast(this.modelTransformOutputS3Location()));
            }
            case "sagemakerIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sagemakerIamRoleArn()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
            case "customModelTransformParameters": {
                return Optional.ofNullable(clazz.cast(this.customModelTransformParameters()));
            }
            case "baseProcessingInstanceType": {
                return Optional.ofNullable(clazz.cast(this.baseProcessingInstanceType()));
            }
            case "baseProcessingInstanceVolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.baseProcessingInstanceVolumeSizeInGB()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "volumeEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKMSKey()));
            }
            case "s3OutputEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.s3OutputEncryptionKMSKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("dataProcessingJobId", DATA_PROCESSING_JOB_ID_FIELD);
        map.put("mlModelTrainingJobId", ML_MODEL_TRAINING_JOB_ID_FIELD);
        map.put("trainingJobName", TRAINING_JOB_NAME_FIELD);
        map.put("modelTransformOutputS3Location", MODEL_TRANSFORM_OUTPUT_S3_LOCATION_FIELD);
        map.put("sagemakerIamRoleArn", SAGEMAKER_IAM_ROLE_ARN_FIELD);
        map.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
        map.put("customModelTransformParameters", CUSTOM_MODEL_TRANSFORM_PARAMETERS_FIELD);
        map.put("baseProcessingInstanceType", BASE_PROCESSING_INSTANCE_TYPE_FIELD);
        map.put("baseProcessingInstanceVolumeSizeInGB", BASE_PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("volumeEncryptionKMSKey", VOLUME_ENCRYPTION_KMS_KEY_FIELD);
        map.put("s3OutputEncryptionKMSKey", S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMlModelTransformJobRequest, T> g) {
        return obj -> g.apply((StartMlModelTransformJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String id;
        private String dataProcessingJobId;
        private String mlModelTrainingJobId;
        private String trainingJobName;
        private String modelTransformOutputS3Location;
        private String sagemakerIamRoleArn;
        private String neptuneIamRoleArn;
        private CustomModelTransformParameters customModelTransformParameters;
        private String baseProcessingInstanceType;
        private Integer baseProcessingInstanceVolumeSizeInGB;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String volumeEncryptionKMSKey;
        private String s3OutputEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlModelTransformJobRequest model) {
            super(model);
            this.id(model.id);
            this.dataProcessingJobId(model.dataProcessingJobId);
            this.mlModelTrainingJobId(model.mlModelTrainingJobId);
            this.trainingJobName(model.trainingJobName);
            this.modelTransformOutputS3Location(model.modelTransformOutputS3Location);
            this.sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
            this.customModelTransformParameters(model.customModelTransformParameters);
            this.baseProcessingInstanceType(model.baseProcessingInstanceType);
            this.baseProcessingInstanceVolumeSizeInGB(model.baseProcessingInstanceVolumeSizeInGB);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            this.s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDataProcessingJobId() {
            return this.dataProcessingJobId;
        }

        public final void setDataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
        }

        @Override
        public final Builder dataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
            return this;
        }

        public final String getMlModelTrainingJobId() {
            return this.mlModelTrainingJobId;
        }

        public final void setMlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
        }

        @Override
        public final Builder mlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
            return this;
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final String getModelTransformOutputS3Location() {
            return this.modelTransformOutputS3Location;
        }

        public final void setModelTransformOutputS3Location(String modelTransformOutputS3Location) {
            this.modelTransformOutputS3Location = modelTransformOutputS3Location;
        }

        @Override
        public final Builder modelTransformOutputS3Location(String modelTransformOutputS3Location) {
            this.modelTransformOutputS3Location = modelTransformOutputS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return this.sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final CustomModelTransformParameters.Builder getCustomModelTransformParameters() {
            return this.customModelTransformParameters != null ? this.customModelTransformParameters.toBuilder() : null;
        }

        public final void setCustomModelTransformParameters(CustomModelTransformParameters.BuilderImpl customModelTransformParameters) {
            this.customModelTransformParameters = customModelTransformParameters != null ? customModelTransformParameters.build() : null;
        }

        @Override
        public final Builder customModelTransformParameters(CustomModelTransformParameters customModelTransformParameters) {
            this.customModelTransformParameters = customModelTransformParameters;
            return this;
        }

        public final String getBaseProcessingInstanceType() {
            return this.baseProcessingInstanceType;
        }

        public final void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
        }

        @Override
        public final Builder baseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
            return this;
        }

        public final Integer getBaseProcessingInstanceVolumeSizeInGB() {
            return this.baseProcessingInstanceVolumeSizeInGB;
        }

        public final void setBaseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
            this.baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder baseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
            this.baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return this.volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return this.s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlModelTransformJobRequest build() {
            return new StartMlModelTransformJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMlModelTransformJobRequest> {
        public Builder id(String var1);

        public Builder dataProcessingJobId(String var1);

        public Builder mlModelTrainingJobId(String var1);

        public Builder trainingJobName(String var1);

        public Builder modelTransformOutputS3Location(String var1);

        public Builder sagemakerIamRoleArn(String var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder customModelTransformParameters(CustomModelTransformParameters var1);

        default public Builder customModelTransformParameters(Consumer<CustomModelTransformParameters.Builder> customModelTransformParameters) {
            return this.customModelTransformParameters((CustomModelTransformParameters)((CustomModelTransformParameters.Builder)CustomModelTransformParameters.builder().applyMutation(customModelTransformParameters)).build());
        }

        public Builder baseProcessingInstanceType(String var1);

        public Builder baseProcessingInstanceVolumeSizeInGB(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder volumeEncryptionKMSKey(String var1);

        public Builder s3OutputEncryptionKMSKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

