/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.Encoding;
import software.amazon.awssdk.services.neptunedata.model.IteratorType;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertygraphStreamRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, GetPropertygraphStreamRequest> {
    private static final SdkField<Long> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("limit").getter(GetPropertygraphStreamRequest.getter(GetPropertygraphStreamRequest::limit)).setter(GetPropertygraphStreamRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> ITERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iteratorType").getter(GetPropertygraphStreamRequest.getter(GetPropertygraphStreamRequest::iteratorTypeAsString)).setter(GetPropertygraphStreamRequest.setter(Builder::iteratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("iteratorType").build()}).build();
    private static final SdkField<Long> COMMIT_NUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("commitNum").getter(GetPropertygraphStreamRequest.getter(GetPropertygraphStreamRequest::commitNum)).setter(GetPropertygraphStreamRequest.setter(Builder::commitNum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("commitNum").build()}).build();
    private static final SdkField<Long> OP_NUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("opNum").getter(GetPropertygraphStreamRequest.getter(GetPropertygraphStreamRequest::opNum)).setter(GetPropertygraphStreamRequest.setter(Builder::opNum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("opNum").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encoding").getter(GetPropertygraphStreamRequest.getter(GetPropertygraphStreamRequest::encodingAsString)).setter(GetPropertygraphStreamRequest.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept-Encoding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, ITERATOR_TYPE_FIELD, COMMIT_NUM_FIELD, OP_NUM_FIELD, ENCODING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPropertygraphStreamRequest.memberNameToFieldInitializer();
    private final Long limit;
    private final String iteratorType;
    private final Long commitNum;
    private final Long opNum;
    private final String encoding;

    private GetPropertygraphStreamRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.iteratorType = builder.iteratorType;
        this.commitNum = builder.commitNum;
        this.opNum = builder.opNum;
        this.encoding = builder.encoding;
    }

    public final Long limit() {
        return this.limit;
    }

    public final IteratorType iteratorType() {
        return IteratorType.fromValue(this.iteratorType);
    }

    public final String iteratorTypeAsString() {
        return this.iteratorType;
    }

    public final Long commitNum() {
        return this.commitNum;
    }

    public final Long opNum() {
        return this.opNum;
    }

    public final Encoding encoding() {
        return Encoding.fromValue(this.encoding);
    }

    public final String encodingAsString() {
        return this.encoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.iteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitNum());
        hashCode = 31 * hashCode + Objects.hashCode(this.opNum());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertygraphStreamRequest)) {
            return false;
        }
        GetPropertygraphStreamRequest other = (GetPropertygraphStreamRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.iteratorTypeAsString(), other.iteratorTypeAsString()) && Objects.equals(this.commitNum(), other.commitNum()) && Objects.equals(this.opNum(), other.opNum()) && Objects.equals(this.encodingAsString(), other.encodingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertygraphStreamRequest").add("Limit", (Object)this.limit()).add("IteratorType", (Object)this.iteratorTypeAsString()).add("CommitNum", (Object)this.commitNum()).add("OpNum", (Object)this.opNum()).add("Encoding", (Object)this.encodingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "iteratorType": {
                return Optional.ofNullable(clazz.cast(this.iteratorTypeAsString()));
            }
            case "commitNum": {
                return Optional.ofNullable(clazz.cast(this.commitNum()));
            }
            case "opNum": {
                return Optional.ofNullable(clazz.cast(this.opNum()));
            }
            case "encoding": {
                return Optional.ofNullable(clazz.cast(this.encodingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", LIMIT_FIELD);
        map.put("iteratorType", ITERATOR_TYPE_FIELD);
        map.put("commitNum", COMMIT_NUM_FIELD);
        map.put("opNum", OP_NUM_FIELD);
        map.put("Accept-Encoding", ENCODING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPropertygraphStreamRequest, T> g) {
        return obj -> g.apply((GetPropertygraphStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private Long limit;
        private String iteratorType;
        private Long commitNum;
        private Long opNum;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertygraphStreamRequest model) {
            super(model);
            this.limit(model.limit);
            this.iteratorType(model.iteratorType);
            this.commitNum(model.commitNum);
            this.opNum(model.opNum);
            this.encoding(model.encoding);
        }

        public final Long getLimit() {
            return this.limit;
        }

        public final void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public final String getIteratorType() {
            return this.iteratorType;
        }

        public final void setIteratorType(String iteratorType) {
            this.iteratorType = iteratorType;
        }

        @Override
        public final Builder iteratorType(String iteratorType) {
            this.iteratorType = iteratorType;
            return this;
        }

        @Override
        public final Builder iteratorType(IteratorType iteratorType) {
            this.iteratorType(iteratorType == null ? null : iteratorType.toString());
            return this;
        }

        public final Long getCommitNum() {
            return this.commitNum;
        }

        public final void setCommitNum(Long commitNum) {
            this.commitNum = commitNum;
        }

        @Override
        public final Builder commitNum(Long commitNum) {
            this.commitNum = commitNum;
            return this;
        }

        public final Long getOpNum() {
            return this.opNum;
        }

        public final void setOpNum(Long opNum) {
            this.opNum = opNum;
        }

        @Override
        public final Builder opNum(Long opNum) {
            this.opNum = opNum;
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(Encoding encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPropertygraphStreamRequest build() {
            return new GetPropertygraphStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertygraphStreamRequest> {
        public Builder limit(Long var1);

        public Builder iteratorType(String var1);

        public Builder iteratorType(IteratorType var1);

        public Builder commitNum(Long var1);

        public Builder opNum(Long var1);

        public Builder encoding(String var1);

        public Builder encoding(Encoding var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

