/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.StatisticsSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Statistics> {
    private static final SdkField<Boolean> AUTO_COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoCompute").getter(Statistics.getter(Statistics::autoCompute)).setter(Statistics.setter(Builder::autoCompute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoCompute").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(Statistics.getter(Statistics::active)).setter(Statistics.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<String> STATISTICS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statisticsId").getter(Statistics.getter(Statistics::statisticsId)).setter(Statistics.setter(Builder::statisticsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticsId").build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("date").getter(Statistics.getter(Statistics::date)).setter(Statistics.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("note").getter(Statistics.getter(Statistics::note)).setter(Statistics.setter(Builder::note)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()}).build();
    private static final SdkField<StatisticsSummary> SIGNATURE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signatureInfo").getter(Statistics.getter(Statistics::signatureInfo)).setter(Statistics.setter(Builder::signatureInfo)).constructor(StatisticsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_COMPUTE_FIELD, ACTIVE_FIELD, STATISTICS_ID_FIELD, DATE_FIELD, NOTE_FIELD, SIGNATURE_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Statistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean autoCompute;
    private final Boolean active;
    private final String statisticsId;
    private final Instant date;
    private final String note;
    private final StatisticsSummary signatureInfo;

    private Statistics(BuilderImpl builder) {
        this.autoCompute = builder.autoCompute;
        this.active = builder.active;
        this.statisticsId = builder.statisticsId;
        this.date = builder.date;
        this.note = builder.note;
        this.signatureInfo = builder.signatureInfo;
    }

    public final Boolean autoCompute() {
        return this.autoCompute;
    }

    public final Boolean active() {
        return this.active;
    }

    public final String statisticsId() {
        return this.statisticsId;
    }

    public final Instant date() {
        return this.date;
    }

    public final String note() {
        return this.note;
    }

    public final StatisticsSummary signatureInfo() {
        return this.signatureInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCompute());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics)obj;
        return Objects.equals(this.autoCompute(), other.autoCompute()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.statisticsId(), other.statisticsId()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.note(), other.note()) && Objects.equals(this.signatureInfo(), other.signatureInfo());
    }

    public final String toString() {
        return ToString.builder((String)"Statistics").add("AutoCompute", (Object)this.autoCompute()).add("Active", (Object)this.active()).add("StatisticsId", (Object)this.statisticsId()).add("Date", (Object)this.date()).add("Note", (Object)this.note()).add("SignatureInfo", (Object)this.signatureInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoCompute": {
                return Optional.ofNullable(clazz.cast(this.autoCompute()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "statisticsId": {
                return Optional.ofNullable(clazz.cast(this.statisticsId()));
            }
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "signatureInfo": {
                return Optional.ofNullable(clazz.cast(this.signatureInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoCompute", AUTO_COMPUTE_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("statisticsId", STATISTICS_ID_FIELD);
        map.put("date", DATE_FIELD);
        map.put("note", NOTE_FIELD);
        map.put("signatureInfo", SIGNATURE_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoCompute;
        private Boolean active;
        private String statisticsId;
        private Instant date;
        private String note;
        private StatisticsSummary signatureInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            this.autoCompute(model.autoCompute);
            this.active(model.active);
            this.statisticsId(model.statisticsId);
            this.date(model.date);
            this.note(model.note);
            this.signatureInfo(model.signatureInfo);
        }

        public final Boolean getAutoCompute() {
            return this.autoCompute;
        }

        public final void setAutoCompute(Boolean autoCompute) {
            this.autoCompute = autoCompute;
        }

        @Override
        public final Builder autoCompute(Boolean autoCompute) {
            this.autoCompute = autoCompute;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getStatisticsId() {
            return this.statisticsId;
        }

        public final void setStatisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
        }

        @Override
        public final Builder statisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
            return this;
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final StatisticsSummary.Builder getSignatureInfo() {
            return this.signatureInfo != null ? this.signatureInfo.toBuilder() : null;
        }

        public final void setSignatureInfo(StatisticsSummary.BuilderImpl signatureInfo) {
            this.signatureInfo = signatureInfo != null ? signatureInfo.build() : null;
        }

        @Override
        public final Builder signatureInfo(StatisticsSummary signatureInfo) {
            this.signatureInfo = signatureInfo;
            return this;
        }

        public Statistics build() {
            return new Statistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Statistics> {
        public Builder autoCompute(Boolean var1);

        public Builder active(Boolean var1);

        public Builder statisticsId(String var1);

        public Builder date(Instant var1);

        public Builder note(String var1);

        public Builder signatureInfo(StatisticsSummary var1);

        default public Builder signatureInfo(Consumer<StatisticsSummary.Builder> signatureInfo) {
            return this.signatureInfo((StatisticsSummary)((StatisticsSummary.Builder)StatisticsSummary.builder().applyMutation(signatureInfo)).build());
        }
    }
}

