/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunedata.model.SparqlData;
import software.amazon.awssdk.services.neptunedata.model.StringValuedMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparqlRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparqlRecord> {
    private static final SdkField<Long> COMMIT_TIMESTAMP_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("commitTimestampInMillis").getter(SparqlRecord.getter(SparqlRecord::commitTimestampInMillis)).setter(SparqlRecord.setter(Builder::commitTimestampInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventId").getter(SparqlRecord.getter(SparqlRecord::eventId)).setter(SparqlRecord.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SparqlData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(SparqlRecord.getter(SparqlRecord::data)).setter(SparqlRecord.setter(Builder::data)).constructor(SparqlData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> OP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("op").getter(SparqlRecord.getter(SparqlRecord::op)).setter(SparqlRecord.setter(Builder::op)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("op").build()}).build();
    private static final SdkField<Boolean> IS_LAST_OP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLastOp").getter(SparqlRecord.getter(SparqlRecord::isLastOp)).setter(SparqlRecord.setter(Builder::isLastOp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLastOp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_TIMESTAMP_IN_MILLIS_FIELD, EVENT_ID_FIELD, DATA_FIELD, OP_FIELD, IS_LAST_OP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparqlRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long commitTimestampInMillis;
    private final Map<String, String> eventId;
    private final SparqlData data;
    private final String op;
    private final Boolean isLastOp;

    private SparqlRecord(BuilderImpl builder) {
        this.commitTimestampInMillis = builder.commitTimestampInMillis;
        this.eventId = builder.eventId;
        this.data = builder.data;
        this.op = builder.op;
        this.isLastOp = builder.isLastOp;
    }

    public final Long commitTimestampInMillis() {
        return this.commitTimestampInMillis;
    }

    public final boolean hasEventId() {
        return this.eventId != null && !(this.eventId instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> eventId() {
        return this.eventId;
    }

    public final SparqlData data() {
        return this.data;
    }

    public final String op() {
        return this.op;
    }

    public final Boolean isLastOp() {
        return this.isLastOp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitTimestampInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventId() ? this.eventId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.op());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLastOp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparqlRecord)) {
            return false;
        }
        SparqlRecord other = (SparqlRecord)obj;
        return Objects.equals(this.commitTimestampInMillis(), other.commitTimestampInMillis()) && this.hasEventId() == other.hasEventId() && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.op(), other.op()) && Objects.equals(this.isLastOp(), other.isLastOp());
    }

    public final String toString() {
        return ToString.builder((String)"SparqlRecord").add("CommitTimestampInMillis", (Object)this.commitTimestampInMillis()).add("EventId", this.hasEventId() ? this.eventId() : null).add("Data", (Object)this.data()).add("Op", (Object)this.op()).add("IsLastOp", (Object)this.isLastOp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitTimestampInMillis": {
                return Optional.ofNullable(clazz.cast(this.commitTimestampInMillis()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "op": {
                return Optional.ofNullable(clazz.cast(this.op()));
            }
            case "isLastOp": {
                return Optional.ofNullable(clazz.cast(this.isLastOp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commitTimestamp", COMMIT_TIMESTAMP_IN_MILLIS_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("data", DATA_FIELD);
        map.put("op", OP_FIELD);
        map.put("isLastOp", IS_LAST_OP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparqlRecord, T> g) {
        return obj -> g.apply((SparqlRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long commitTimestampInMillis;
        private Map<String, String> eventId = DefaultSdkAutoConstructMap.getInstance();
        private SparqlData data;
        private String op;
        private Boolean isLastOp;

        private BuilderImpl() {
        }

        private BuilderImpl(SparqlRecord model) {
            this.commitTimestampInMillis(model.commitTimestampInMillis);
            this.eventId(model.eventId);
            this.data(model.data);
            this.op(model.op);
            this.isLastOp(model.isLastOp);
        }

        public final Long getCommitTimestampInMillis() {
            return this.commitTimestampInMillis;
        }

        public final void setCommitTimestampInMillis(Long commitTimestampInMillis) {
            this.commitTimestampInMillis = commitTimestampInMillis;
        }

        @Override
        public final Builder commitTimestampInMillis(Long commitTimestampInMillis) {
            this.commitTimestampInMillis = commitTimestampInMillis;
            return this;
        }

        public final Map<String, String> getEventId() {
            if (this.eventId instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.eventId;
        }

        public final void setEventId(Map<String, String> eventId) {
            this.eventId = StringValuedMapCopier.copy(eventId);
        }

        @Override
        public final Builder eventId(Map<String, String> eventId) {
            this.eventId = StringValuedMapCopier.copy(eventId);
            return this;
        }

        public final SparqlData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(SparqlData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(SparqlData data) {
            this.data = data;
            return this;
        }

        public final String getOp() {
            return this.op;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        public final Boolean getIsLastOp() {
            return this.isLastOp;
        }

        public final void setIsLastOp(Boolean isLastOp) {
            this.isLastOp = isLastOp;
        }

        @Override
        public final Builder isLastOp(Boolean isLastOp) {
            this.isLastOp = isLastOp;
            return this;
        }

        public SparqlRecord build() {
            return new SparqlRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparqlRecord> {
        public Builder commitTimestampInMillis(Long var1);

        public Builder eventId(Map<String, String> var1);

        public Builder data(SparqlData var1);

        default public Builder data(Consumer<SparqlData.Builder> data) {
            return this.data((SparqlData)((SparqlData.Builder)SparqlData.builder().applyMutation(data)).build());
        }

        public Builder op(String var1);

        public Builder isLastOp(Boolean var1);
    }
}

