/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoaderJobStatusRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, GetLoaderJobStatusRequest> {
    private static final SdkField<String> LOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadId").getter(GetLoaderJobStatusRequest.getter(GetLoaderJobStatusRequest::loadId)).setter(GetLoaderJobStatusRequest.setter(Builder::loadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("loadId").build()}).build();
    private static final SdkField<Boolean> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("details").getter(GetLoaderJobStatusRequest.getter(GetLoaderJobStatusRequest::details)).setter(GetLoaderJobStatusRequest.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("details").build()}).build();
    private static final SdkField<Boolean> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("errors").getter(GetLoaderJobStatusRequest.getter(GetLoaderJobStatusRequest::errors)).setter(GetLoaderJobStatusRequest.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("errors").build()}).build();
    private static final SdkField<Integer> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("page").getter(GetLoaderJobStatusRequest.getter(GetLoaderJobStatusRequest::page)).setter(GetLoaderJobStatusRequest.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page").build()}).build();
    private static final SdkField<Integer> ERRORS_PER_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("errorsPerPage").getter(GetLoaderJobStatusRequest.getter(GetLoaderJobStatusRequest::errorsPerPage)).setter(GetLoaderJobStatusRequest.setter(Builder::errorsPerPage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("errorsPerPage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_ID_FIELD, DETAILS_FIELD, ERRORS_FIELD, PAGE_FIELD, ERRORS_PER_PAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLoaderJobStatusRequest.memberNameToFieldInitializer();
    private final String loadId;
    private final Boolean details;
    private final Boolean errors;
    private final Integer page;
    private final Integer errorsPerPage;

    private GetLoaderJobStatusRequest(BuilderImpl builder) {
        super(builder);
        this.loadId = builder.loadId;
        this.details = builder.details;
        this.errors = builder.errors;
        this.page = builder.page;
        this.errorsPerPage = builder.errorsPerPage;
    }

    public final String loadId() {
        return this.loadId;
    }

    public final Boolean details() {
        return this.details;
    }

    public final Boolean errors() {
        return this.errors;
    }

    public final Integer page() {
        return this.page;
    }

    public final Integer errorsPerPage() {
        return this.errorsPerPage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorsPerPage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoaderJobStatusRequest)) {
            return false;
        }
        GetLoaderJobStatusRequest other = (GetLoaderJobStatusRequest)((Object)obj);
        return Objects.equals(this.loadId(), other.loadId()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.page(), other.page()) && Objects.equals(this.errorsPerPage(), other.errorsPerPage());
    }

    public final String toString() {
        return ToString.builder((String)"GetLoaderJobStatusRequest").add("LoadId", (Object)this.loadId()).add("Details", (Object)this.details()).add("Errors", (Object)this.errors()).add("Page", (Object)this.page()).add("ErrorsPerPage", (Object)this.errorsPerPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadId": {
                return Optional.ofNullable(clazz.cast(this.loadId()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "errorsPerPage": {
                return Optional.ofNullable(clazz.cast(this.errorsPerPage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loadId", LOAD_ID_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("page", PAGE_FIELD);
        map.put("errorsPerPage", ERRORS_PER_PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLoaderJobStatusRequest, T> g) {
        return obj -> g.apply((GetLoaderJobStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String loadId;
        private Boolean details;
        private Boolean errors;
        private Integer page;
        private Integer errorsPerPage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoaderJobStatusRequest model) {
            super(model);
            this.loadId(model.loadId);
            this.details(model.details);
            this.errors(model.errors);
            this.page(model.page);
            this.errorsPerPage(model.errorsPerPage);
        }

        public final String getLoadId() {
            return this.loadId;
        }

        public final void setLoadId(String loadId) {
            this.loadId = loadId;
        }

        @Override
        public final Builder loadId(String loadId) {
            this.loadId = loadId;
            return this;
        }

        public final Boolean getDetails() {
            return this.details;
        }

        public final void setDetails(Boolean details) {
            this.details = details;
        }

        @Override
        public final Builder details(Boolean details) {
            this.details = details;
            return this;
        }

        public final Boolean getErrors() {
            return this.errors;
        }

        public final void setErrors(Boolean errors) {
            this.errors = errors;
        }

        @Override
        public final Builder errors(Boolean errors) {
            this.errors = errors;
            return this;
        }

        public final Integer getPage() {
            return this.page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final Integer getErrorsPerPage() {
            return this.errorsPerPage;
        }

        public final void setErrorsPerPage(Integer errorsPerPage) {
            this.errorsPerPage = errorsPerPage;
        }

        @Override
        public final Builder errorsPerPage(Integer errorsPerPage) {
            this.errorsPerPage = errorsPerPage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLoaderJobStatusRequest build() {
            return new GetLoaderJobStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLoaderJobStatusRequest> {
        public Builder loadId(String var1);

        public Builder details(Boolean var1);

        public Builder errors(Boolean var1);

        public Builder page(Integer var1);

        public Builder errorsPerPage(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

