/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.services.neptunedata.model.OpenCypherExplainMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteOpenCypherExplainQueryRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, ExecuteOpenCypherExplainQueryRequest> {
    private static final SdkField<String> OPEN_CYPHER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("openCypherQuery").getter(ExecuteOpenCypherExplainQueryRequest.getter(ExecuteOpenCypherExplainQueryRequest::openCypherQuery)).setter(ExecuteOpenCypherExplainQueryRequest.setter(Builder::openCypherQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameters").getter(ExecuteOpenCypherExplainQueryRequest.getter(ExecuteOpenCypherExplainQueryRequest::parameters)).setter(ExecuteOpenCypherExplainQueryRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<String> EXPLAIN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("explainMode").getter(ExecuteOpenCypherExplainQueryRequest.getter(ExecuteOpenCypherExplainQueryRequest::explainModeAsString)).setter(ExecuteOpenCypherExplainQueryRequest.setter(Builder::explainMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("explain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_CYPHER_QUERY_FIELD, PARAMETERS_FIELD, EXPLAIN_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteOpenCypherExplainQueryRequest.memberNameToFieldInitializer();
    private final String openCypherQuery;
    private final String parameters;
    private final String explainMode;

    private ExecuteOpenCypherExplainQueryRequest(BuilderImpl builder) {
        super(builder);
        this.openCypherQuery = builder.openCypherQuery;
        this.parameters = builder.parameters;
        this.explainMode = builder.explainMode;
    }

    public final String openCypherQuery() {
        return this.openCypherQuery;
    }

    public final String parameters() {
        return this.parameters;
    }

    public final OpenCypherExplainMode explainMode() {
        return OpenCypherExplainMode.fromValue(this.explainMode);
    }

    public final String explainModeAsString() {
        return this.explainMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openCypherQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteOpenCypherExplainQueryRequest)) {
            return false;
        }
        ExecuteOpenCypherExplainQueryRequest other = (ExecuteOpenCypherExplainQueryRequest)((Object)obj);
        return Objects.equals(this.openCypherQuery(), other.openCypherQuery()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.explainModeAsString(), other.explainModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteOpenCypherExplainQueryRequest").add("OpenCypherQuery", (Object)this.openCypherQuery()).add("Parameters", (Object)this.parameters()).add("ExplainMode", (Object)this.explainModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "openCypherQuery": {
                return Optional.ofNullable(clazz.cast(this.openCypherQuery()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "explainMode": {
                return Optional.ofNullable(clazz.cast(this.explainModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("query", OPEN_CYPHER_QUERY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("explain", EXPLAIN_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteOpenCypherExplainQueryRequest, T> g) {
        return obj -> g.apply((ExecuteOpenCypherExplainQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String openCypherQuery;
        private String parameters;
        private String explainMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteOpenCypherExplainQueryRequest model) {
            super(model);
            this.openCypherQuery(model.openCypherQuery);
            this.parameters(model.parameters);
            this.explainMode(model.explainMode);
        }

        public final String getOpenCypherQuery() {
            return this.openCypherQuery;
        }

        public final void setOpenCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
        }

        @Override
        public final Builder openCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
            return this;
        }

        public final String getParameters() {
            return this.parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getExplainMode() {
            return this.explainMode;
        }

        public final void setExplainMode(String explainMode) {
            this.explainMode = explainMode;
        }

        @Override
        public final Builder explainMode(String explainMode) {
            this.explainMode = explainMode;
            return this;
        }

        @Override
        public final Builder explainMode(OpenCypherExplainMode explainMode) {
            this.explainMode(explainMode == null ? null : explainMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteOpenCypherExplainQueryRequest build() {
            return new ExecuteOpenCypherExplainQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteOpenCypherExplainQueryRequest> {
        public Builder openCypherQuery(String var1);

        public Builder parameters(String var1);

        public Builder explainMode(String var1);

        public Builder explainMode(OpenCypherExplainMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

