/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.ClassesCopier;
import software.amazon.awssdk.services.neptunedata.model.LongValuedMapListCopier;
import software.amazon.awssdk.services.neptunedata.model.SubjectStructure;
import software.amazon.awssdk.services.neptunedata.model.SubjectStructuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDFGraphSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDFGraphSummary> {
    private static final SdkField<Long> NUM_DISTINCT_SUBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numDistinctSubjects").getter(RDFGraphSummary.getter(RDFGraphSummary::numDistinctSubjects)).setter(RDFGraphSummary.setter(Builder::numDistinctSubjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDistinctSubjects").build()}).build();
    private static final SdkField<Long> NUM_DISTINCT_PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numDistinctPredicates").getter(RDFGraphSummary.getter(RDFGraphSummary::numDistinctPredicates)).setter(RDFGraphSummary.setter(Builder::numDistinctPredicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDistinctPredicates").build()}).build();
    private static final SdkField<Long> NUM_QUADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numQuads").getter(RDFGraphSummary.getter(RDFGraphSummary::numQuads)).setter(RDFGraphSummary.setter(Builder::numQuads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numQuads").build()}).build();
    private static final SdkField<Long> NUM_CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numClasses").getter(RDFGraphSummary.getter(RDFGraphSummary::numClasses)).setter(RDFGraphSummary.setter(Builder::numClasses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numClasses").build()}).build();
    private static final SdkField<List<String>> CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("classes").getter(RDFGraphSummary.getter(RDFGraphSummary::classes)).setter(RDFGraphSummary.setter(Builder::classes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, Long>>> PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("predicates").getter(RDFGraphSummary.getter(RDFGraphSummary::predicates)).setter(RDFGraphSummary.setter(Builder::predicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<SubjectStructure>> SUBJECT_STRUCTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subjectStructures").getter(RDFGraphSummary.getter(RDFGraphSummary::subjectStructures)).setter(RDFGraphSummary.setter(Builder::subjectStructures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectStructures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubjectStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_DISTINCT_SUBJECTS_FIELD, NUM_DISTINCT_PREDICATES_FIELD, NUM_QUADS_FIELD, NUM_CLASSES_FIELD, CLASSES_FIELD, PREDICATES_FIELD, SUBJECT_STRUCTURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RDFGraphSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long numDistinctSubjects;
    private final Long numDistinctPredicates;
    private final Long numQuads;
    private final Long numClasses;
    private final List<String> classes;
    private final List<Map<String, Long>> predicates;
    private final List<SubjectStructure> subjectStructures;

    private RDFGraphSummary(BuilderImpl builder) {
        this.numDistinctSubjects = builder.numDistinctSubjects;
        this.numDistinctPredicates = builder.numDistinctPredicates;
        this.numQuads = builder.numQuads;
        this.numClasses = builder.numClasses;
        this.classes = builder.classes;
        this.predicates = builder.predicates;
        this.subjectStructures = builder.subjectStructures;
    }

    public final Long numDistinctSubjects() {
        return this.numDistinctSubjects;
    }

    public final Long numDistinctPredicates() {
        return this.numDistinctPredicates;
    }

    public final Long numQuads() {
        return this.numQuads;
    }

    public final Long numClasses() {
        return this.numClasses;
    }

    public final boolean hasClasses() {
        return this.classes != null && !(this.classes instanceof SdkAutoConstructList);
    }

    public final List<String> classes() {
        return this.classes;
    }

    public final boolean hasPredicates() {
        return this.predicates != null && !(this.predicates instanceof SdkAutoConstructList);
    }

    public final List<Map<String, Long>> predicates() {
        return this.predicates;
    }

    public final boolean hasSubjectStructures() {
        return this.subjectStructures != null && !(this.subjectStructures instanceof SdkAutoConstructList);
    }

    public final List<SubjectStructure> subjectStructures() {
        return this.subjectStructures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numDistinctSubjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.numDistinctPredicates());
        hashCode = 31 * hashCode + Objects.hashCode(this.numQuads());
        hashCode = 31 * hashCode + Objects.hashCode(this.numClasses());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClasses() ? this.classes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredicates() ? this.predicates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectStructures() ? this.subjectStructures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDFGraphSummary)) {
            return false;
        }
        RDFGraphSummary other = (RDFGraphSummary)obj;
        return Objects.equals(this.numDistinctSubjects(), other.numDistinctSubjects()) && Objects.equals(this.numDistinctPredicates(), other.numDistinctPredicates()) && Objects.equals(this.numQuads(), other.numQuads()) && Objects.equals(this.numClasses(), other.numClasses()) && this.hasClasses() == other.hasClasses() && Objects.equals(this.classes(), other.classes()) && this.hasPredicates() == other.hasPredicates() && Objects.equals(this.predicates(), other.predicates()) && this.hasSubjectStructures() == other.hasSubjectStructures() && Objects.equals(this.subjectStructures(), other.subjectStructures());
    }

    public final String toString() {
        return ToString.builder((String)"RDFGraphSummary").add("NumDistinctSubjects", (Object)this.numDistinctSubjects()).add("NumDistinctPredicates", (Object)this.numDistinctPredicates()).add("NumQuads", (Object)this.numQuads()).add("NumClasses", (Object)this.numClasses()).add("Classes", this.hasClasses() ? this.classes() : null).add("Predicates", this.hasPredicates() ? this.predicates() : null).add("SubjectStructures", this.hasSubjectStructures() ? this.subjectStructures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numDistinctSubjects": {
                return Optional.ofNullable(clazz.cast(this.numDistinctSubjects()));
            }
            case "numDistinctPredicates": {
                return Optional.ofNullable(clazz.cast(this.numDistinctPredicates()));
            }
            case "numQuads": {
                return Optional.ofNullable(clazz.cast(this.numQuads()));
            }
            case "numClasses": {
                return Optional.ofNullable(clazz.cast(this.numClasses()));
            }
            case "classes": {
                return Optional.ofNullable(clazz.cast(this.classes()));
            }
            case "predicates": {
                return Optional.ofNullable(clazz.cast(this.predicates()));
            }
            case "subjectStructures": {
                return Optional.ofNullable(clazz.cast(this.subjectStructures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("numDistinctSubjects", NUM_DISTINCT_SUBJECTS_FIELD);
        map.put("numDistinctPredicates", NUM_DISTINCT_PREDICATES_FIELD);
        map.put("numQuads", NUM_QUADS_FIELD);
        map.put("numClasses", NUM_CLASSES_FIELD);
        map.put("classes", CLASSES_FIELD);
        map.put("predicates", PREDICATES_FIELD);
        map.put("subjectStructures", SUBJECT_STRUCTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RDFGraphSummary, T> g) {
        return obj -> g.apply((RDFGraphSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numDistinctSubjects;
        private Long numDistinctPredicates;
        private Long numQuads;
        private Long numClasses;
        private List<String> classes = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, Long>> predicates = DefaultSdkAutoConstructList.getInstance();
        private List<SubjectStructure> subjectStructures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDFGraphSummary model) {
            this.numDistinctSubjects(model.numDistinctSubjects);
            this.numDistinctPredicates(model.numDistinctPredicates);
            this.numQuads(model.numQuads);
            this.numClasses(model.numClasses);
            this.classes(model.classes);
            this.predicates(model.predicates);
            this.subjectStructures(model.subjectStructures);
        }

        public final Long getNumDistinctSubjects() {
            return this.numDistinctSubjects;
        }

        public final void setNumDistinctSubjects(Long numDistinctSubjects) {
            this.numDistinctSubjects = numDistinctSubjects;
        }

        @Override
        public final Builder numDistinctSubjects(Long numDistinctSubjects) {
            this.numDistinctSubjects = numDistinctSubjects;
            return this;
        }

        public final Long getNumDistinctPredicates() {
            return this.numDistinctPredicates;
        }

        public final void setNumDistinctPredicates(Long numDistinctPredicates) {
            this.numDistinctPredicates = numDistinctPredicates;
        }

        @Override
        public final Builder numDistinctPredicates(Long numDistinctPredicates) {
            this.numDistinctPredicates = numDistinctPredicates;
            return this;
        }

        public final Long getNumQuads() {
            return this.numQuads;
        }

        public final void setNumQuads(Long numQuads) {
            this.numQuads = numQuads;
        }

        @Override
        public final Builder numQuads(Long numQuads) {
            this.numQuads = numQuads;
            return this;
        }

        public final Long getNumClasses() {
            return this.numClasses;
        }

        public final void setNumClasses(Long numClasses) {
            this.numClasses = numClasses;
        }

        @Override
        public final Builder numClasses(Long numClasses) {
            this.numClasses = numClasses;
            return this;
        }

        public final Collection<String> getClasses() {
            if (this.classes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classes;
        }

        public final void setClasses(Collection<String> classes) {
            this.classes = ClassesCopier.copy(classes);
        }

        @Override
        public final Builder classes(Collection<String> classes) {
            this.classes = ClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(String ... classes) {
            this.classes(Arrays.asList(classes));
            return this;
        }

        public final Collection<? extends Map<String, Long>> getPredicates() {
            if (this.predicates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.predicates;
        }

        public final void setPredicates(Collection<? extends Map<String, Long>> predicates) {
            this.predicates = LongValuedMapListCopier.copy(predicates);
        }

        @Override
        public final Builder predicates(Collection<? extends Map<String, Long>> predicates) {
            this.predicates = LongValuedMapListCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(Map<String, Long> ... predicates) {
            this.predicates(Arrays.asList(predicates));
            return this;
        }

        public final List<SubjectStructure.Builder> getSubjectStructures() {
            List<SubjectStructure.Builder> result = SubjectStructuresCopier.copyToBuilder(this.subjectStructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjectStructures(Collection<SubjectStructure.BuilderImpl> subjectStructures) {
            this.subjectStructures = SubjectStructuresCopier.copyFromBuilder(subjectStructures);
        }

        @Override
        public final Builder subjectStructures(Collection<SubjectStructure> subjectStructures) {
            this.subjectStructures = SubjectStructuresCopier.copy(subjectStructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectStructures(SubjectStructure ... subjectStructures) {
            this.subjectStructures(Arrays.asList(subjectStructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectStructures(Consumer<SubjectStructure.Builder> ... subjectStructures) {
            this.subjectStructures(Stream.of(subjectStructures).map(c -> (SubjectStructure)((SubjectStructure.Builder)SubjectStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RDFGraphSummary build() {
            return new RDFGraphSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDFGraphSummary> {
        public Builder numDistinctSubjects(Long var1);

        public Builder numDistinctPredicates(Long var1);

        public Builder numQuads(Long var1);

        public Builder numClasses(Long var1);

        public Builder classes(Collection<String> var1);

        public Builder classes(String ... var1);

        public Builder predicates(Collection<? extends Map<String, Long>> var1);

        public Builder predicates(Map<String, Long> ... var1);

        public Builder subjectStructures(Collection<SubjectStructure> var1);

        public Builder subjectStructures(SubjectStructure ... var1);

        public Builder subjectStructures(Consumer<SubjectStructure.Builder> ... var1);
    }
}

