/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition;
import software.amazon.awssdk.services.neptunedata.model.MlModelsCopier;
import software.amazon.awssdk.services.neptunedata.model.MlResourceDefinition;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlModelTrainingJobResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetMlModelTrainingJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::status)).setter(GetMlModelTrainingJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::id)).setter(GetMlModelTrainingJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MlResourceDefinition> PROCESSING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("processingJob").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::processingJob)).setter(GetMlModelTrainingJobResponse.setter(Builder::processingJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingJob").build()}).build();
    private static final SdkField<MlResourceDefinition> HPO_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hpoJob").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::hpoJob)).setter(GetMlModelTrainingJobResponse.setter(Builder::hpoJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoJob").build()}).build();
    private static final SdkField<MlResourceDefinition> MODEL_TRANSFORM_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelTransformJob").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::modelTransformJob)).setter(GetMlModelTrainingJobResponse.setter(Builder::modelTransformJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTransformJob").build()}).build();
    private static final SdkField<List<MlConfigDefinition>> ML_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mlModels").getter(GetMlModelTrainingJobResponse.getter(GetMlModelTrainingJobResponse::mlModels)).setter(GetMlModelTrainingJobResponse.setter(Builder::mlModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MlConfigDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD, PROCESSING_JOB_FIELD, HPO_JOB_FIELD, MODEL_TRANSFORM_JOB_FIELD, ML_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("id", ID_FIELD);
            this.put("processingJob", PROCESSING_JOB_FIELD);
            this.put("hpoJob", HPO_JOB_FIELD);
            this.put("modelTransformJob", MODEL_TRANSFORM_JOB_FIELD);
            this.put("mlModels", ML_MODELS_FIELD);
        }
    });
    private final String status;
    private final String id;
    private final MlResourceDefinition processingJob;
    private final MlResourceDefinition hpoJob;
    private final MlResourceDefinition modelTransformJob;
    private final List<MlConfigDefinition> mlModels;

    private GetMlModelTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.processingJob = builder.processingJob;
        this.hpoJob = builder.hpoJob;
        this.modelTransformJob = builder.modelTransformJob;
        this.mlModels = builder.mlModels;
    }

    public final String status() {
        return this.status;
    }

    public final String id() {
        return this.id;
    }

    public final MlResourceDefinition processingJob() {
        return this.processingJob;
    }

    public final MlResourceDefinition hpoJob() {
        return this.hpoJob;
    }

    public final MlResourceDefinition modelTransformJob() {
        return this.modelTransformJob;
    }

    public final boolean hasMlModels() {
        return this.mlModels != null && !(this.mlModels instanceof SdkAutoConstructList);
    }

    public final List<MlConfigDefinition> mlModels() {
        return this.mlModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMlModels() ? this.mlModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelTrainingJobResponse)) {
            return false;
        }
        GetMlModelTrainingJobResponse other = (GetMlModelTrainingJobResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.processingJob(), other.processingJob()) && Objects.equals(this.hpoJob(), other.hpoJob()) && Objects.equals(this.modelTransformJob(), other.modelTransformJob()) && this.hasMlModels() == other.hasMlModels() && Objects.equals(this.mlModels(), other.mlModels());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlModelTrainingJobResponse").add("Status", (Object)this.status()).add("Id", (Object)this.id()).add("ProcessingJob", (Object)this.processingJob()).add("HpoJob", (Object)this.hpoJob()).add("ModelTransformJob", (Object)this.modelTransformJob()).add("MlModels", this.hasMlModels() ? this.mlModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "processingJob": {
                return Optional.ofNullable(clazz.cast(this.processingJob()));
            }
            case "hpoJob": {
                return Optional.ofNullable(clazz.cast(this.hpoJob()));
            }
            case "modelTransformJob": {
                return Optional.ofNullable(clazz.cast(this.modelTransformJob()));
            }
            case "mlModels": {
                return Optional.ofNullable(clazz.cast(this.mlModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelTrainingJobResponse, T> g) {
        return obj -> g.apply((GetMlModelTrainingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String status;
        private String id;
        private MlResourceDefinition processingJob;
        private MlResourceDefinition hpoJob;
        private MlResourceDefinition modelTransformJob;
        private List<MlConfigDefinition> mlModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelTrainingJobResponse model) {
            super(model);
            this.status(model.status);
            this.id(model.id);
            this.processingJob(model.processingJob);
            this.hpoJob(model.hpoJob);
            this.modelTransformJob(model.modelTransformJob);
            this.mlModels(model.mlModels);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getProcessingJob() {
            return this.processingJob != null ? this.processingJob.toBuilder() : null;
        }

        public final void setProcessingJob(MlResourceDefinition.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        @Override
        public final Builder processingJob(MlResourceDefinition processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final MlResourceDefinition.Builder getHpoJob() {
            return this.hpoJob != null ? this.hpoJob.toBuilder() : null;
        }

        public final void setHpoJob(MlResourceDefinition.BuilderImpl hpoJob) {
            this.hpoJob = hpoJob != null ? hpoJob.build() : null;
        }

        @Override
        public final Builder hpoJob(MlResourceDefinition hpoJob) {
            this.hpoJob = hpoJob;
            return this;
        }

        public final MlResourceDefinition.Builder getModelTransformJob() {
            return this.modelTransformJob != null ? this.modelTransformJob.toBuilder() : null;
        }

        public final void setModelTransformJob(MlResourceDefinition.BuilderImpl modelTransformJob) {
            this.modelTransformJob = modelTransformJob != null ? modelTransformJob.build() : null;
        }

        @Override
        public final Builder modelTransformJob(MlResourceDefinition modelTransformJob) {
            this.modelTransformJob = modelTransformJob;
            return this;
        }

        public final List<MlConfigDefinition.Builder> getMlModels() {
            List<MlConfigDefinition.Builder> result = MlModelsCopier.copyToBuilder(this.mlModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMlModels(Collection<MlConfigDefinition.BuilderImpl> mlModels) {
            this.mlModels = MlModelsCopier.copyFromBuilder(mlModels);
        }

        @Override
        public final Builder mlModels(Collection<MlConfigDefinition> mlModels) {
            this.mlModels = MlModelsCopier.copy(mlModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlModels(MlConfigDefinition ... mlModels) {
            this.mlModels(Arrays.asList(mlModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlModels(Consumer<MlConfigDefinition.Builder> ... mlModels) {
            this.mlModels(Stream.of(mlModels).map(c -> (MlConfigDefinition)((MlConfigDefinition.Builder)MlConfigDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMlModelTrainingJobResponse build() {
            return new GetMlModelTrainingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlModelTrainingJobResponse> {
        public Builder status(String var1);

        public Builder id(String var1);

        public Builder processingJob(MlResourceDefinition var1);

        default public Builder processingJob(Consumer<MlResourceDefinition.Builder> processingJob) {
            return this.processingJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(processingJob)).build());
        }

        public Builder hpoJob(MlResourceDefinition var1);

        default public Builder hpoJob(Consumer<MlResourceDefinition.Builder> hpoJob) {
            return this.hpoJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(hpoJob)).build());
        }

        public Builder modelTransformJob(MlResourceDefinition var1);

        default public Builder modelTransformJob(Consumer<MlResourceDefinition.Builder> modelTransformJob) {
            return this.modelTransformJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(modelTransformJob)).build());
        }

        public Builder mlModels(Collection<MlConfigDefinition> var1);

        public Builder mlModels(MlConfigDefinition ... var1);

        public Builder mlModels(Consumer<MlConfigDefinition.Builder> ... var1);
    }
}

