/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.CustomModelTrainingParameters;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.services.neptunedata.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMlModelTrainingJobRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, StartMlModelTrainingJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::id)).setter(StartMlModelTrainingJobRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PREVIOUS_MODEL_TRAINING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previousModelTrainingJobId").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::previousModelTrainingJobId)).setter(StartMlModelTrainingJobRequest.setter(Builder::previousModelTrainingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousModelTrainingJobId").build()}).build();
    private static final SdkField<String> DATA_PROCESSING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProcessingJobId").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::dataProcessingJobId)).setter(StartMlModelTrainingJobRequest.setter(Builder::dataProcessingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingJobId").build()}).build();
    private static final SdkField<String> TRAIN_MODEL_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainModelS3Location").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::trainModelS3Location)).setter(StartMlModelTrainingJobRequest.setter(Builder::trainModelS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainModelS3Location").build()}).build();
    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sagemakerIamRoleArn").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::sagemakerIamRoleArn)).setter(StartMlModelTrainingJobRequest.setter(Builder::sagemakerIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::neptuneIamRoleArn)).setter(StartMlModelTrainingJobRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()}).build();
    private static final SdkField<String> BASE_PROCESSING_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseProcessingInstanceType").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::baseProcessingInstanceType)).setter(StartMlModelTrainingJobRequest.setter(Builder::baseProcessingInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingInstanceType").build()}).build();
    private static final SdkField<String> TRAINING_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingInstanceType").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::trainingInstanceType)).setter(StartMlModelTrainingJobRequest.setter(Builder::trainingInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInstanceType").build()}).build();
    private static final SdkField<Integer> TRAINING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("trainingInstanceVolumeSizeInGB").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::trainingInstanceVolumeSizeInGB)).setter(StartMlModelTrainingJobRequest.setter(Builder::trainingInstanceVolumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInstanceVolumeSizeInGB").build()}).build();
    private static final SdkField<Integer> TRAINING_TIME_OUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("trainingTimeOutInSeconds").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::trainingTimeOutInSeconds)).setter(StartMlModelTrainingJobRequest.setter(Builder::trainingTimeOutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingTimeOutInSeconds").build()}).build();
    private static final SdkField<Integer> MAX_HPO_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxHPONumberOfTrainingJobs").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::maxHPONumberOfTrainingJobs)).setter(StartMlModelTrainingJobRequest.setter(Builder::maxHPONumberOfTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHPONumberOfTrainingJobs").build()}).build();
    private static final SdkField<Integer> MAX_HPO_PARALLEL_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxHPOParallelTrainingJobs").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::maxHPOParallelTrainingJobs)).setter(StartMlModelTrainingJobRequest.setter(Builder::maxHPOParallelTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHPOParallelTrainingJobs").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::subnets)).setter(StartMlModelTrainingJobRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::securityGroupIds)).setter(StartMlModelTrainingJobRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeEncryptionKMSKey").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::volumeEncryptionKMSKey)).setter(StartMlModelTrainingJobRequest.setter(Builder::volumeEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build()}).build();
    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3OutputEncryptionKMSKey").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::s3OutputEncryptionKMSKey)).setter(StartMlModelTrainingJobRequest.setter(Builder::s3OutputEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableManagedSpotTraining").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::enableManagedSpotTraining)).setter(StartMlModelTrainingJobRequest.setter(Builder::enableManagedSpotTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableManagedSpotTraining").build()}).build();
    private static final SdkField<CustomModelTrainingParameters> CUSTOM_MODEL_TRAINING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customModelTrainingParameters").getter(StartMlModelTrainingJobRequest.getter(StartMlModelTrainingJobRequest::customModelTrainingParameters)).setter(StartMlModelTrainingJobRequest.setter(Builder::customModelTrainingParameters)).constructor(CustomModelTrainingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTrainingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PREVIOUS_MODEL_TRAINING_JOB_ID_FIELD, DATA_PROCESSING_JOB_ID_FIELD, TRAIN_MODEL_S3_LOCATION_FIELD, SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, BASE_PROCESSING_INSTANCE_TYPE_FIELD, TRAINING_INSTANCE_TYPE_FIELD, TRAINING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, TRAINING_TIME_OUT_IN_SECONDS_FIELD, MAX_HPO_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_HPO_PARALLEL_TRAINING_JOBS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD, S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD, CUSTOM_MODEL_TRAINING_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("previousModelTrainingJobId", PREVIOUS_MODEL_TRAINING_JOB_ID_FIELD);
            this.put("dataProcessingJobId", DATA_PROCESSING_JOB_ID_FIELD);
            this.put("trainModelS3Location", TRAIN_MODEL_S3_LOCATION_FIELD);
            this.put("sagemakerIamRoleArn", SAGEMAKER_IAM_ROLE_ARN_FIELD);
            this.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
            this.put("baseProcessingInstanceType", BASE_PROCESSING_INSTANCE_TYPE_FIELD);
            this.put("trainingInstanceType", TRAINING_INSTANCE_TYPE_FIELD);
            this.put("trainingInstanceVolumeSizeInGB", TRAINING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD);
            this.put("trainingTimeOutInSeconds", TRAINING_TIME_OUT_IN_SECONDS_FIELD);
            this.put("maxHPONumberOfTrainingJobs", MAX_HPO_NUMBER_OF_TRAINING_JOBS_FIELD);
            this.put("maxHPOParallelTrainingJobs", MAX_HPO_PARALLEL_TRAINING_JOBS_FIELD);
            this.put("subnets", SUBNETS_FIELD);
            this.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
            this.put("volumeEncryptionKMSKey", VOLUME_ENCRYPTION_KMS_KEY_FIELD);
            this.put("s3OutputEncryptionKMSKey", S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD);
            this.put("enableManagedSpotTraining", ENABLE_MANAGED_SPOT_TRAINING_FIELD);
            this.put("customModelTrainingParameters", CUSTOM_MODEL_TRAINING_PARAMETERS_FIELD);
        }
    });
    private final String id;
    private final String previousModelTrainingJobId;
    private final String dataProcessingJobId;
    private final String trainModelS3Location;
    private final String sagemakerIamRoleArn;
    private final String neptuneIamRoleArn;
    private final String baseProcessingInstanceType;
    private final String trainingInstanceType;
    private final Integer trainingInstanceVolumeSizeInGB;
    private final Integer trainingTimeOutInSeconds;
    private final Integer maxHPONumberOfTrainingJobs;
    private final Integer maxHPOParallelTrainingJobs;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String volumeEncryptionKMSKey;
    private final String s3OutputEncryptionKMSKey;
    private final Boolean enableManagedSpotTraining;
    private final CustomModelTrainingParameters customModelTrainingParameters;

    private StartMlModelTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.previousModelTrainingJobId = builder.previousModelTrainingJobId;
        this.dataProcessingJobId = builder.dataProcessingJobId;
        this.trainModelS3Location = builder.trainModelS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.baseProcessingInstanceType = builder.baseProcessingInstanceType;
        this.trainingInstanceType = builder.trainingInstanceType;
        this.trainingInstanceVolumeSizeInGB = builder.trainingInstanceVolumeSizeInGB;
        this.trainingTimeOutInSeconds = builder.trainingTimeOutInSeconds;
        this.maxHPONumberOfTrainingJobs = builder.maxHPONumberOfTrainingJobs;
        this.maxHPOParallelTrainingJobs = builder.maxHPOParallelTrainingJobs;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.customModelTrainingParameters = builder.customModelTrainingParameters;
    }

    public final String id() {
        return this.id;
    }

    public final String previousModelTrainingJobId() {
        return this.previousModelTrainingJobId;
    }

    public final String dataProcessingJobId() {
        return this.dataProcessingJobId;
    }

    public final String trainModelS3Location() {
        return this.trainModelS3Location;
    }

    public final String sagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    public final String baseProcessingInstanceType() {
        return this.baseProcessingInstanceType;
    }

    public final String trainingInstanceType() {
        return this.trainingInstanceType;
    }

    public final Integer trainingInstanceVolumeSizeInGB() {
        return this.trainingInstanceVolumeSizeInGB;
    }

    public final Integer trainingTimeOutInSeconds() {
        return this.trainingTimeOutInSeconds;
    }

    public final Integer maxHPONumberOfTrainingJobs() {
        return this.maxHPONumberOfTrainingJobs;
    }

    public final Integer maxHPOParallelTrainingJobs() {
        return this.maxHPOParallelTrainingJobs;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String volumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    public final String s3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    public final Boolean enableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public final CustomModelTrainingParameters customModelTrainingParameters() {
        return this.customModelTrainingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainModelS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseProcessingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingTimeOutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHPONumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHPOParallelTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelTrainingParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlModelTrainingJobRequest)) {
            return false;
        }
        StartMlModelTrainingJobRequest other = (StartMlModelTrainingJobRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.previousModelTrainingJobId(), other.previousModelTrainingJobId()) && Objects.equals(this.dataProcessingJobId(), other.dataProcessingJobId()) && Objects.equals(this.trainModelS3Location(), other.trainModelS3Location()) && Objects.equals(this.sagemakerIamRoleArn(), other.sagemakerIamRoleArn()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn()) && Objects.equals(this.baseProcessingInstanceType(), other.baseProcessingInstanceType()) && Objects.equals(this.trainingInstanceType(), other.trainingInstanceType()) && Objects.equals(this.trainingInstanceVolumeSizeInGB(), other.trainingInstanceVolumeSizeInGB()) && Objects.equals(this.trainingTimeOutInSeconds(), other.trainingTimeOutInSeconds()) && Objects.equals(this.maxHPONumberOfTrainingJobs(), other.maxHPONumberOfTrainingJobs()) && Objects.equals(this.maxHPOParallelTrainingJobs(), other.maxHPOParallelTrainingJobs()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey()) && Objects.equals(this.s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey()) && Objects.equals(this.enableManagedSpotTraining(), other.enableManagedSpotTraining()) && Objects.equals(this.customModelTrainingParameters(), other.customModelTrainingParameters());
    }

    public final String toString() {
        return ToString.builder((String)"StartMlModelTrainingJobRequest").add("Id", (Object)this.id()).add("PreviousModelTrainingJobId", (Object)this.previousModelTrainingJobId()).add("DataProcessingJobId", (Object)this.dataProcessingJobId()).add("TrainModelS3Location", (Object)this.trainModelS3Location()).add("SagemakerIamRoleArn", (Object)this.sagemakerIamRoleArn()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).add("BaseProcessingInstanceType", (Object)this.baseProcessingInstanceType()).add("TrainingInstanceType", (Object)this.trainingInstanceType()).add("TrainingInstanceVolumeSizeInGB", (Object)this.trainingInstanceVolumeSizeInGB()).add("TrainingTimeOutInSeconds", (Object)this.trainingTimeOutInSeconds()).add("MaxHPONumberOfTrainingJobs", (Object)this.maxHPONumberOfTrainingJobs()).add("MaxHPOParallelTrainingJobs", (Object)this.maxHPOParallelTrainingJobs()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("VolumeEncryptionKMSKey", (Object)this.volumeEncryptionKMSKey()).add("S3OutputEncryptionKMSKey", (Object)this.s3OutputEncryptionKMSKey()).add("EnableManagedSpotTraining", (Object)this.enableManagedSpotTraining()).add("CustomModelTrainingParameters", (Object)this.customModelTrainingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "previousModelTrainingJobId": {
                return Optional.ofNullable(clazz.cast(this.previousModelTrainingJobId()));
            }
            case "dataProcessingJobId": {
                return Optional.ofNullable(clazz.cast(this.dataProcessingJobId()));
            }
            case "trainModelS3Location": {
                return Optional.ofNullable(clazz.cast(this.trainModelS3Location()));
            }
            case "sagemakerIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sagemakerIamRoleArn()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
            case "baseProcessingInstanceType": {
                return Optional.ofNullable(clazz.cast(this.baseProcessingInstanceType()));
            }
            case "trainingInstanceType": {
                return Optional.ofNullable(clazz.cast(this.trainingInstanceType()));
            }
            case "trainingInstanceVolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.trainingInstanceVolumeSizeInGB()));
            }
            case "trainingTimeOutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.trainingTimeOutInSeconds()));
            }
            case "maxHPONumberOfTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxHPONumberOfTrainingJobs()));
            }
            case "maxHPOParallelTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxHPOParallelTrainingJobs()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "volumeEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKMSKey()));
            }
            case "s3OutputEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.s3OutputEncryptionKMSKey()));
            }
            case "enableManagedSpotTraining": {
                return Optional.ofNullable(clazz.cast(this.enableManagedSpotTraining()));
            }
            case "customModelTrainingParameters": {
                return Optional.ofNullable(clazz.cast(this.customModelTrainingParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartMlModelTrainingJobRequest, T> g) {
        return obj -> g.apply((StartMlModelTrainingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String id;
        private String previousModelTrainingJobId;
        private String dataProcessingJobId;
        private String trainModelS3Location;
        private String sagemakerIamRoleArn;
        private String neptuneIamRoleArn;
        private String baseProcessingInstanceType;
        private String trainingInstanceType;
        private Integer trainingInstanceVolumeSizeInGB;
        private Integer trainingTimeOutInSeconds;
        private Integer maxHPONumberOfTrainingJobs;
        private Integer maxHPOParallelTrainingJobs;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String volumeEncryptionKMSKey;
        private String s3OutputEncryptionKMSKey;
        private Boolean enableManagedSpotTraining;
        private CustomModelTrainingParameters customModelTrainingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlModelTrainingJobRequest model) {
            super(model);
            this.id(model.id);
            this.previousModelTrainingJobId(model.previousModelTrainingJobId);
            this.dataProcessingJobId(model.dataProcessingJobId);
            this.trainModelS3Location(model.trainModelS3Location);
            this.sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
            this.baseProcessingInstanceType(model.baseProcessingInstanceType);
            this.trainingInstanceType(model.trainingInstanceType);
            this.trainingInstanceVolumeSizeInGB(model.trainingInstanceVolumeSizeInGB);
            this.trainingTimeOutInSeconds(model.trainingTimeOutInSeconds);
            this.maxHPONumberOfTrainingJobs(model.maxHPONumberOfTrainingJobs);
            this.maxHPOParallelTrainingJobs(model.maxHPOParallelTrainingJobs);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            this.s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
            this.enableManagedSpotTraining(model.enableManagedSpotTraining);
            this.customModelTrainingParameters(model.customModelTrainingParameters);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPreviousModelTrainingJobId() {
            return this.previousModelTrainingJobId;
        }

        public final void setPreviousModelTrainingJobId(String previousModelTrainingJobId) {
            this.previousModelTrainingJobId = previousModelTrainingJobId;
        }

        @Override
        public final Builder previousModelTrainingJobId(String previousModelTrainingJobId) {
            this.previousModelTrainingJobId = previousModelTrainingJobId;
            return this;
        }

        public final String getDataProcessingJobId() {
            return this.dataProcessingJobId;
        }

        public final void setDataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
        }

        @Override
        public final Builder dataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
            return this;
        }

        public final String getTrainModelS3Location() {
            return this.trainModelS3Location;
        }

        public final void setTrainModelS3Location(String trainModelS3Location) {
            this.trainModelS3Location = trainModelS3Location;
        }

        @Override
        public final Builder trainModelS3Location(String trainModelS3Location) {
            this.trainModelS3Location = trainModelS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return this.sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getBaseProcessingInstanceType() {
            return this.baseProcessingInstanceType;
        }

        public final void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
        }

        @Override
        public final Builder baseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
            return this;
        }

        public final String getTrainingInstanceType() {
            return this.trainingInstanceType;
        }

        public final void setTrainingInstanceType(String trainingInstanceType) {
            this.trainingInstanceType = trainingInstanceType;
        }

        @Override
        public final Builder trainingInstanceType(String trainingInstanceType) {
            this.trainingInstanceType = trainingInstanceType;
            return this;
        }

        public final Integer getTrainingInstanceVolumeSizeInGB() {
            return this.trainingInstanceVolumeSizeInGB;
        }

        public final void setTrainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
            this.trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder trainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
            this.trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB;
            return this;
        }

        public final Integer getTrainingTimeOutInSeconds() {
            return this.trainingTimeOutInSeconds;
        }

        public final void setTrainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
            this.trainingTimeOutInSeconds = trainingTimeOutInSeconds;
        }

        @Override
        public final Builder trainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
            this.trainingTimeOutInSeconds = trainingTimeOutInSeconds;
            return this;
        }

        public final Integer getMaxHPONumberOfTrainingJobs() {
            return this.maxHPONumberOfTrainingJobs;
        }

        public final void setMaxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
            this.maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs;
        }

        @Override
        public final Builder maxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
            this.maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs;
            return this;
        }

        public final Integer getMaxHPOParallelTrainingJobs() {
            return this.maxHPOParallelTrainingJobs;
        }

        public final void setMaxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
            this.maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs;
        }

        @Override
        public final Builder maxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
            this.maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return this.volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return this.s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return this.enableManagedSpotTraining;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final CustomModelTrainingParameters.Builder getCustomModelTrainingParameters() {
            return this.customModelTrainingParameters != null ? this.customModelTrainingParameters.toBuilder() : null;
        }

        public final void setCustomModelTrainingParameters(CustomModelTrainingParameters.BuilderImpl customModelTrainingParameters) {
            this.customModelTrainingParameters = customModelTrainingParameters != null ? customModelTrainingParameters.build() : null;
        }

        @Override
        public final Builder customModelTrainingParameters(CustomModelTrainingParameters customModelTrainingParameters) {
            this.customModelTrainingParameters = customModelTrainingParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlModelTrainingJobRequest build() {
            return new StartMlModelTrainingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMlModelTrainingJobRequest> {
        public Builder id(String var1);

        public Builder previousModelTrainingJobId(String var1);

        public Builder dataProcessingJobId(String var1);

        public Builder trainModelS3Location(String var1);

        public Builder sagemakerIamRoleArn(String var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder baseProcessingInstanceType(String var1);

        public Builder trainingInstanceType(String var1);

        public Builder trainingInstanceVolumeSizeInGB(Integer var1);

        public Builder trainingTimeOutInSeconds(Integer var1);

        public Builder maxHPONumberOfTrainingJobs(Integer var1);

        public Builder maxHPOParallelTrainingJobs(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder volumeEncryptionKMSKey(String var1);

        public Builder s3OutputEncryptionKMSKey(String var1);

        public Builder enableManagedSpotTraining(Boolean var1);

        public Builder customModelTrainingParameters(CustomModelTrainingParameters var1);

        default public Builder customModelTrainingParameters(Consumer<CustomModelTrainingParameters.Builder> customModelTrainingParameters) {
            return this.customModelTrainingParameters((CustomModelTrainingParameters)((CustomModelTrainingParameters.Builder)CustomModelTrainingParameters.builder().applyMutation(customModelTrainingParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

