/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.services.neptunedata.model.RDFGraphSummaryValueMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRdfGraphSummaryResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetRdfGraphSummaryResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("statusCode").getter(GetRdfGraphSummaryResponse.getter(GetRdfGraphSummaryResponse::statusCode)).setter(GetRdfGraphSummaryResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()}).build();
    private static final SdkField<RDFGraphSummaryValueMap> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("payload").getter(GetRdfGraphSummaryResponse.getter(GetRdfGraphSummaryResponse::payload)).setter(GetRdfGraphSummaryResponse.setter(Builder::payload)).constructor(RDFGraphSummaryValueMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("statusCode", STATUS_CODE_FIELD);
            this.put("payload", PAYLOAD_FIELD);
        }
    });
    private final Integer statusCodeValue;
    private final RDFGraphSummaryValueMap payload;

    private GetRdfGraphSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.payload = builder.payload;
    }

    public final Integer statusCode() {
        return this.statusCodeValue;
    }

    public final RDFGraphSummaryValueMap payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRdfGraphSummaryResponse)) {
            return false;
        }
        GetRdfGraphSummaryResponse other = (GetRdfGraphSummaryResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"GetRdfGraphSummaryResponse").add("StatusCode", (Object)this.statusCode()).add("Payload", (Object)this.payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRdfGraphSummaryResponse, T> g) {
        return obj -> g.apply((GetRdfGraphSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private Integer statusCodeValue;
        private RDFGraphSummaryValueMap payload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRdfGraphSummaryResponse model) {
            super(model);
            this.statusCode(model.statusCodeValue);
            this.payload(model.payload);
        }

        public final Integer getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final RDFGraphSummaryValueMap.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(RDFGraphSummaryValueMap.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(RDFGraphSummaryValueMap payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public GetRdfGraphSummaryResponse build() {
            return new GetRdfGraphSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRdfGraphSummaryResponse> {
        public Builder statusCode(Integer var1);

        public Builder payload(RDFGraphSummaryValueMap var1);

        default public Builder payload(Consumer<RDFGraphSummaryValueMap.Builder> payload) {
            return this.payload((RDFGraphSummaryValueMap)((RDFGraphSummaryValueMap.Builder)RDFGraphSummaryValueMap.builder().applyMutation(payload)).build());
        }
    }
}

