/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlEndpointRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, CreateMlEndpointRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::id)).setter(CreateMlEndpointRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ML_MODEL_TRAINING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlModelTrainingJobId").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::mlModelTrainingJobId)).setter(CreateMlEndpointRequest.setter(Builder::mlModelTrainingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTrainingJobId").build()}).build();
    private static final SdkField<String> ML_MODEL_TRANSFORM_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlModelTransformJobId").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::mlModelTransformJobId)).setter(CreateMlEndpointRequest.setter(Builder::mlModelTransformJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTransformJobId").build()}).build();
    private static final SdkField<Boolean> UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("update").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::update)).setter(CreateMlEndpointRequest.setter(Builder::update)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("update").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::neptuneIamRoleArn)).setter(CreateMlEndpointRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::modelName)).setter(CreateMlEndpointRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::instanceType)).setter(CreateMlEndpointRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("instanceCount").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::instanceCount)).setter(CreateMlEndpointRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeEncryptionKMSKey").getter(CreateMlEndpointRequest.getter(CreateMlEndpointRequest::volumeEncryptionKMSKey)).setter(CreateMlEndpointRequest.setter(Builder::volumeEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ML_MODEL_TRAINING_JOB_ID_FIELD, ML_MODEL_TRANSFORM_JOB_ID_FIELD, UPDATE_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, MODEL_NAME_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD));
    private final String id;
    private final String mlModelTrainingJobId;
    private final String mlModelTransformJobId;
    private final Boolean update;
    private final String neptuneIamRoleArn;
    private final String modelName;
    private final String instanceType;
    private final Integer instanceCount;
    private final String volumeEncryptionKMSKey;

    private CreateMlEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.mlModelTrainingJobId = builder.mlModelTrainingJobId;
        this.mlModelTransformJobId = builder.mlModelTransformJobId;
        this.update = builder.update;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.modelName = builder.modelName;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
    }

    public final String id() {
        return this.id;
    }

    public final String mlModelTrainingJobId() {
        return this.mlModelTrainingJobId;
    }

    public final String mlModelTransformJobId() {
        return this.mlModelTransformJobId;
    }

    public final Boolean update() {
        return this.update;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String volumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTransformJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.update());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKMSKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlEndpointRequest)) {
            return false;
        }
        CreateMlEndpointRequest other = (CreateMlEndpointRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.mlModelTrainingJobId(), other.mlModelTrainingJobId()) && Objects.equals(this.mlModelTransformJobId(), other.mlModelTransformJobId()) && Objects.equals(this.update(), other.update()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMlEndpointRequest").add("Id", (Object)this.id()).add("MlModelTrainingJobId", (Object)this.mlModelTrainingJobId()).add("MlModelTransformJobId", (Object)this.mlModelTransformJobId()).add("Update", (Object)this.update()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).add("ModelName", (Object)this.modelName()).add("InstanceType", (Object)this.instanceType()).add("InstanceCount", (Object)this.instanceCount()).add("VolumeEncryptionKMSKey", (Object)this.volumeEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "mlModelTrainingJobId": {
                return Optional.ofNullable(clazz.cast(this.mlModelTrainingJobId()));
            }
            case "mlModelTransformJobId": {
                return Optional.ofNullable(clazz.cast(this.mlModelTransformJobId()));
            }
            case "update": {
                return Optional.ofNullable(clazz.cast(this.update()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "instanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "volumeEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKMSKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlEndpointRequest, T> g) {
        return obj -> g.apply((CreateMlEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String id;
        private String mlModelTrainingJobId;
        private String mlModelTransformJobId;
        private Boolean update;
        private String neptuneIamRoleArn;
        private String modelName;
        private String instanceType;
        private Integer instanceCount;
        private String volumeEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlEndpointRequest model) {
            super(model);
            this.id(model.id);
            this.mlModelTrainingJobId(model.mlModelTrainingJobId);
            this.mlModelTransformJobId(model.mlModelTransformJobId);
            this.update(model.update);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
            this.modelName(model.modelName);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMlModelTrainingJobId() {
            return this.mlModelTrainingJobId;
        }

        public final void setMlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
        }

        @Override
        public final Builder mlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
            return this;
        }

        public final String getMlModelTransformJobId() {
            return this.mlModelTransformJobId;
        }

        public final void setMlModelTransformJobId(String mlModelTransformJobId) {
            this.mlModelTransformJobId = mlModelTransformJobId;
        }

        @Override
        public final Builder mlModelTransformJobId(String mlModelTransformJobId) {
            this.mlModelTransformJobId = mlModelTransformJobId;
            return this;
        }

        public final Boolean getUpdate() {
            return this.update;
        }

        public final void setUpdate(Boolean update) {
            this.update = update;
        }

        @Override
        public final Builder update(Boolean update) {
            this.update = update;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return this.volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlEndpointRequest build() {
            return new CreateMlEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlEndpointRequest> {
        public Builder id(String var1);

        public Builder mlModelTrainingJobId(String var1);

        public Builder mlModelTransformJobId(String var1);

        public Builder update(Boolean var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder modelName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder volumeEncryptionKMSKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

