/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IteratorType {
    AT_SEQUENCE_NUMBER("AT_SEQUENCE_NUMBER"),
    AFTER_SEQUENCE_NUMBER("AFTER_SEQUENCE_NUMBER"),
    TRIM_HORIZON("TRIM_HORIZON"),
    LATEST("LATEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IteratorType> VALUE_MAP;
    private final String value;

    private IteratorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IteratorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IteratorType> knownValues() {
        EnumSet<IteratorType> knownValues = EnumSet.allOf(IteratorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IteratorType.class, IteratorType::toString);
    }
}

