/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GraphSummaryType {
    BASIC("basic"),
    DETAILED("detailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GraphSummaryType> VALUE_MAP;
    private final String value;

    private GraphSummaryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GraphSummaryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GraphSummaryType> knownValues() {
        EnumSet<GraphSummaryType> knownValues = EnumSet.allOf(GraphSummaryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GraphSummaryType.class, GraphSummaryType::toString);
    }
}

