/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.neptunedata.NeptunedataClient;
import software.amazon.awssdk.services.neptunedata.NeptunedataServiceClientConfiguration;
import software.amazon.awssdk.services.neptunedata.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.BadRequestException;
import software.amazon.awssdk.services.neptunedata.model.BulkLoadIdNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelledByUserException;
import software.amazon.awssdk.services.neptunedata.model.ClientTimeoutException;
import software.amazon.awssdk.services.neptunedata.model.ConcurrentModificationException;
import software.amazon.awssdk.services.neptunedata.model.ConstraintViolationException;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExpiredStreamException;
import software.amazon.awssdk.services.neptunedata.model.FailureByQueryException;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.IllegalArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InternalFailureException;
import software.amazon.awssdk.services.neptunedata.model.InvalidArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InvalidNumericDataException;
import software.amazon.awssdk.services.neptunedata.model.InvalidParameterException;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.LoadUrlAccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.MalformedQueryException;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.MemoryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.MethodNotAllowedException;
import software.amazon.awssdk.services.neptunedata.model.MissingParameterException;
import software.amazon.awssdk.services.neptunedata.model.MlResourceNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataException;
import software.amazon.awssdk.services.neptunedata.model.ParsingException;
import software.amazon.awssdk.services.neptunedata.model.PreconditionsFailedException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitException;
import software.amazon.awssdk.services.neptunedata.model.QueryTooLargeException;
import software.amazon.awssdk.services.neptunedata.model.ReadOnlyViolationException;
import software.amazon.awssdk.services.neptunedata.model.S3Exception;
import software.amazon.awssdk.services.neptunedata.model.ServerShutdownException;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StatisticsNotAvailableException;
import software.amazon.awssdk.services.neptunedata.model.StreamRecordsNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.ThrottlingException;
import software.amazon.awssdk.services.neptunedata.model.TimeLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.TooManyRequestsException;
import software.amazon.awssdk.services.neptunedata.model.UnsupportedOperationException;
import software.amazon.awssdk.services.neptunedata.transform.CancelGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CreateMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeletePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteFastResetRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinProfileQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetEngineStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetGremlinQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetLoaderJobStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetOpenCypherQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetRdfGraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListGremlinQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListLoaderJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlDataProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListOpenCypherQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManagePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManageSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultNeptunedataClient
implements NeptunedataClient {
    private static final Logger log = Logger.loggerFor(DefaultNeptunedataClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final NeptunedataServiceClientConfiguration serviceClientConfiguration;

    protected DefaultNeptunedataClient(NeptunedataServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelGremlinQueryResponse cancelGremlinQuery(CancelGremlinQueryRequest cancelGremlinQueryRequest) throws BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelGremlinQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelGremlinQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelGremlinQuery");
            CancelGremlinQueryResponse cancelGremlinQueryResponse = (CancelGremlinQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelGremlinQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelGremlinQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelGremlinQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelGremlinQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelGremlinQuery$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelLoaderJobResponse cancelLoaderJob(CancelLoaderJobRequest cancelLoaderJobRequest) throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelLoaderJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelLoaderJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelLoaderJob");
            CancelLoaderJobResponse cancelLoaderJobResponse = (CancelLoaderJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelLoaderJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelLoaderJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelLoaderJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelLoaderJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelLoaderJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelMlDataProcessingJobResponse cancelMLDataProcessingJob(CancelMlDataProcessingJobRequest cancelMlDataProcessingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelMlDataProcessingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelMlDataProcessingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelMLDataProcessingJob");
            CancelMlDataProcessingJobResponse cancelMlDataProcessingJobResponse = (CancelMlDataProcessingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelMLDataProcessingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelMlDataProcessingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelMlDataProcessingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelMlDataProcessingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelMLDataProcessingJob$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelMlModelTrainingJobResponse cancelMLModelTrainingJob(CancelMlModelTrainingJobRequest cancelMlModelTrainingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelMlModelTrainingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelMlModelTrainingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelMLModelTrainingJob");
            CancelMlModelTrainingJobResponse cancelMlModelTrainingJobResponse = (CancelMlModelTrainingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelMLModelTrainingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelMlModelTrainingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelMlModelTrainingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelMlModelTrainingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelMLModelTrainingJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelMlModelTransformJobResponse cancelMLModelTransformJob(CancelMlModelTransformJobRequest cancelMlModelTransformJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelMlModelTransformJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelMlModelTransformJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelMLModelTransformJob");
            CancelMlModelTransformJobResponse cancelMlModelTransformJobResponse = (CancelMlModelTransformJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelMLModelTransformJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelMlModelTransformJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelMlModelTransformJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelMlModelTransformJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelMLModelTransformJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelOpenCypherQueryResponse cancelOpenCypherQuery(CancelOpenCypherQueryRequest cancelOpenCypherQueryRequest) throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelOpenCypherQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, cancelOpenCypherQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelOpenCypherQuery");
            CancelOpenCypherQueryResponse cancelOpenCypherQueryResponse = (CancelOpenCypherQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelOpenCypherQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelOpenCypherQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelOpenCypherQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelOpenCypherQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$cancelOpenCypherQuery$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMlEndpointResponse createMLEndpoint(CreateMlEndpointRequest createMlEndpointRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMlEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, createMlEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMLEndpoint");
            CreateMlEndpointResponse createMlEndpointResponse = (CreateMlEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMLEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMlEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMlEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMlEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$createMLEndpoint$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMlEndpointResponse deleteMLEndpoint(DeleteMlEndpointRequest deleteMlEndpointRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMlEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, deleteMlEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMLEndpoint");
            DeleteMlEndpointResponse deleteMlEndpointResponse = (DeleteMlEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMLEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMlEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMlEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMlEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$deleteMLEndpoint$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePropertygraphStatisticsResponse deletePropertygraphStatistics(DeletePropertygraphStatisticsRequest deletePropertygraphStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePropertygraphStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, deletePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePropertygraphStatistics");
            DeletePropertygraphStatisticsResponse deletePropertygraphStatisticsResponse = (DeletePropertygraphStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePropertygraphStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePropertygraphStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePropertygraphStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePropertygraphStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$deletePropertygraphStatistics$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSparqlStatisticsResponse deleteSparqlStatistics(DeleteSparqlStatisticsRequest deleteSparqlStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSparqlStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, deleteSparqlStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSparqlStatistics");
            DeleteSparqlStatisticsResponse deleteSparqlStatisticsResponse = (DeleteSparqlStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSparqlStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSparqlStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSparqlStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSparqlStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$deleteSparqlStatistics$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteFastResetResponse executeFastReset(ExecuteFastResetRequest executeFastResetRequest) throws InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, ServerShutdownException, PreconditionsFailedException, MethodNotAllowedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteFastResetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeFastResetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteFastReset");
            ExecuteFastResetResponse executeFastResetResponse = (ExecuteFastResetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteFastReset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeFastResetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteFastResetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeFastResetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeFastReset$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteGremlinExplainQueryResponse executeGremlinExplainQuery(ExecuteGremlinExplainQueryRequest executeGremlinExplainQueryRequest) throws QueryTooLargeException, BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteGremlinExplainQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeGremlinExplainQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteGremlinExplainQuery");
            ExecuteGremlinExplainQueryResponse executeGremlinExplainQueryResponse = (ExecuteGremlinExplainQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteGremlinExplainQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeGremlinExplainQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteGremlinExplainQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeGremlinExplainQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeGremlinExplainQuery$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteGremlinProfileQueryResponse executeGremlinProfileQuery(ExecuteGremlinProfileQueryRequest executeGremlinProfileQueryRequest) throws QueryTooLargeException, BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteGremlinProfileQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeGremlinProfileQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteGremlinProfileQuery");
            ExecuteGremlinProfileQueryResponse executeGremlinProfileQueryResponse = (ExecuteGremlinProfileQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteGremlinProfileQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeGremlinProfileQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteGremlinProfileQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeGremlinProfileQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeGremlinProfileQuery$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteGremlinQueryResponse executeGremlinQuery(ExecuteGremlinQueryRequest executeGremlinQueryRequest) throws QueryTooLargeException, BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteGremlinQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeGremlinQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteGremlinQuery");
            ExecuteGremlinQueryResponse executeGremlinQueryResponse = (ExecuteGremlinQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteGremlinQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeGremlinQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteGremlinQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeGremlinQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeGremlinQuery$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteOpenCypherExplainQueryResponse executeOpenCypherExplainQuery(ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest) throws QueryTooLargeException, InvalidNumericDataException, BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteOpenCypherExplainQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeOpenCypherExplainQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteOpenCypherExplainQuery");
            ExecuteOpenCypherExplainQueryResponse executeOpenCypherExplainQueryResponse = (ExecuteOpenCypherExplainQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteOpenCypherExplainQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeOpenCypherExplainQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteOpenCypherExplainQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeOpenCypherExplainQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeOpenCypherExplainQuery$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteOpenCypherQueryResponse executeOpenCypherQuery(ExecuteOpenCypherQueryRequest executeOpenCypherQueryRequest) throws QueryTooLargeException, InvalidNumericDataException, BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteOpenCypherQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, executeOpenCypherQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteOpenCypherQuery");
            ExecuteOpenCypherQueryResponse executeOpenCypherQueryResponse = (ExecuteOpenCypherQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteOpenCypherQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeOpenCypherQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteOpenCypherQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeOpenCypherQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$executeOpenCypherQuery$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEngineStatusResponse getEngineStatus(GetEngineStatusRequest getEngineStatusRequest) throws UnsupportedOperationException, InternalFailureException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEngineStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getEngineStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEngineStatus");
            GetEngineStatusResponse getEngineStatusResponse = (GetEngineStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEngineStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEngineStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEngineStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEngineStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getEngineStatus$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGremlinQueryStatusResponse getGremlinQueryStatus(GetGremlinQueryStatusRequest getGremlinQueryStatusRequest) throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGremlinQueryStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getGremlinQueryStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGremlinQueryStatus");
            GetGremlinQueryStatusResponse getGremlinQueryStatusResponse = (GetGremlinQueryStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGremlinQueryStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGremlinQueryStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGremlinQueryStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGremlinQueryStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getGremlinQueryStatus$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoaderJobStatusResponse getLoaderJobStatus(GetLoaderJobStatusRequest getLoaderJobStatusRequest) throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoaderJobStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getLoaderJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoaderJobStatus");
            GetLoaderJobStatusResponse getLoaderJobStatusResponse = (GetLoaderJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoaderJobStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLoaderJobStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoaderJobStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoaderJobStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getLoaderJobStatus$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMlDataProcessingJobResponse getMLDataProcessingJob(GetMlDataProcessingJobRequest getMlDataProcessingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlDataProcessingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getMlDataProcessingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLDataProcessingJob");
            GetMlDataProcessingJobResponse getMlDataProcessingJobResponse = (GetMlDataProcessingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLDataProcessingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMlDataProcessingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMlDataProcessingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMlDataProcessingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getMLDataProcessingJob$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMlEndpointResponse getMLEndpoint(GetMlEndpointRequest getMlEndpointRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getMlEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLEndpoint");
            GetMlEndpointResponse getMlEndpointResponse = (GetMlEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMlEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMlEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMlEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getMLEndpoint$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMlModelTrainingJobResponse getMLModelTrainingJob(GetMlModelTrainingJobRequest getMlModelTrainingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlModelTrainingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getMlModelTrainingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLModelTrainingJob");
            GetMlModelTrainingJobResponse getMlModelTrainingJobResponse = (GetMlModelTrainingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLModelTrainingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMlModelTrainingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMlModelTrainingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMlModelTrainingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getMLModelTrainingJob$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMlModelTransformJobResponse getMLModelTransformJob(GetMlModelTransformJobRequest getMlModelTransformJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlModelTransformJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getMlModelTransformJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLModelTransformJob");
            GetMlModelTransformJobResponse getMlModelTransformJobResponse = (GetMlModelTransformJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLModelTransformJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMlModelTransformJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMlModelTransformJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMlModelTransformJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getMLModelTransformJob$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenCypherQueryStatusResponse getOpenCypherQueryStatus(GetOpenCypherQueryStatusRequest getOpenCypherQueryStatusRequest) throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenCypherQueryStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getOpenCypherQueryStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenCypherQueryStatus");
            GetOpenCypherQueryStatusResponse getOpenCypherQueryStatusResponse = (GetOpenCypherQueryStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenCypherQueryStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOpenCypherQueryStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpenCypherQueryStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpenCypherQueryStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getOpenCypherQueryStatus$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertygraphStatisticsResponse getPropertygraphStatistics(GetPropertygraphStatisticsRequest getPropertygraphStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPropertygraphStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getPropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPropertygraphStatistics");
            GetPropertygraphStatisticsResponse getPropertygraphStatisticsResponse = (GetPropertygraphStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPropertygraphStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPropertygraphStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPropertygraphStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPropertygraphStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getPropertygraphStatistics$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertygraphStreamResponse getPropertygraphStream(GetPropertygraphStreamRequest getPropertygraphStreamRequest) throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException, MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException, ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPropertygraphStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getPropertygraphStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPropertygraphStream");
            GetPropertygraphStreamResponse getPropertygraphStreamResponse = (GetPropertygraphStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPropertygraphStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPropertygraphStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPropertygraphStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPropertygraphStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getPropertygraphStream$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertygraphSummaryResponse getPropertygraphSummary(GetPropertygraphSummaryRequest getPropertygraphSummaryRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPropertygraphSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getPropertygraphSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPropertygraphSummary");
            GetPropertygraphSummaryResponse getPropertygraphSummaryResponse = (GetPropertygraphSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPropertygraphSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPropertygraphSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPropertygraphSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPropertygraphSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getPropertygraphSummary$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRdfGraphSummaryResponse getRDFGraphSummary(GetRdfGraphSummaryRequest getRdfGraphSummaryRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRdfGraphSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getRdfGraphSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRDFGraphSummary");
            GetRdfGraphSummaryResponse getRdfGraphSummaryResponse = (GetRdfGraphSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRDFGraphSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRdfGraphSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRdfGraphSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRdfGraphSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getRDFGraphSummary$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSparqlStatisticsResponse getSparqlStatistics(GetSparqlStatisticsRequest getSparqlStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSparqlStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getSparqlStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSparqlStatistics");
            GetSparqlStatisticsResponse getSparqlStatisticsResponse = (GetSparqlStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSparqlStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSparqlStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSparqlStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSparqlStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getSparqlStatistics$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSparqlStreamResponse getSparqlStream(GetSparqlStreamRequest getSparqlStreamRequest) throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException, MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException, ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSparqlStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, getSparqlStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSparqlStream");
            GetSparqlStreamResponse getSparqlStreamResponse = (GetSparqlStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSparqlStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSparqlStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSparqlStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSparqlStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$getSparqlStream$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGremlinQueriesResponse listGremlinQueries(ListGremlinQueriesRequest listGremlinQueriesRequest) throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGremlinQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listGremlinQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGremlinQueries");
            ListGremlinQueriesResponse listGremlinQueriesResponse = (ListGremlinQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGremlinQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGremlinQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGremlinQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGremlinQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listGremlinQueries$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLoaderJobsResponse listLoaderJobs(ListLoaderJobsRequest listLoaderJobsRequest) throws UnsupportedOperationException, BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, InternalFailureException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLoaderJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listLoaderJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLoaderJobs");
            ListLoaderJobsResponse listLoaderJobsResponse = (ListLoaderJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLoaderJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLoaderJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLoaderJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLoaderJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listLoaderJobs$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMlDataProcessingJobsResponse listMLDataProcessingJobs(ListMlDataProcessingJobsRequest listMlDataProcessingJobsRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMlDataProcessingJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listMlDataProcessingJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMLDataProcessingJobs");
            ListMlDataProcessingJobsResponse listMlDataProcessingJobsResponse = (ListMlDataProcessingJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMLDataProcessingJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMlDataProcessingJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMlDataProcessingJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMlDataProcessingJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listMLDataProcessingJobs$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMlEndpointsResponse listMLEndpoints(ListMlEndpointsRequest listMlEndpointsRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMlEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listMlEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMLEndpoints");
            ListMlEndpointsResponse listMlEndpointsResponse = (ListMlEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMLEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMlEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMlEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMlEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listMLEndpoints$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMlModelTrainingJobsResponse listMLModelTrainingJobs(ListMlModelTrainingJobsRequest listMlModelTrainingJobsRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMlModelTrainingJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listMlModelTrainingJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMLModelTrainingJobs");
            ListMlModelTrainingJobsResponse listMlModelTrainingJobsResponse = (ListMlModelTrainingJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMLModelTrainingJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMlModelTrainingJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMlModelTrainingJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMlModelTrainingJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listMLModelTrainingJobs$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMlModelTransformJobsResponse listMLModelTransformJobs(ListMlModelTransformJobsRequest listMlModelTransformJobsRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMlModelTransformJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listMlModelTransformJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMLModelTransformJobs");
            ListMlModelTransformJobsResponse listMlModelTransformJobsResponse = (ListMlModelTransformJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMLModelTransformJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMlModelTransformJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMlModelTransformJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMlModelTransformJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listMLModelTransformJobs$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOpenCypherQueriesResponse listOpenCypherQueries(ListOpenCypherQueriesRequest listOpenCypherQueriesRequest) throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOpenCypherQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, listOpenCypherQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOpenCypherQueries");
            ListOpenCypherQueriesResponse listOpenCypherQueriesResponse = (ListOpenCypherQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOpenCypherQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOpenCypherQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOpenCypherQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOpenCypherQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$listOpenCypherQueries$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagePropertygraphStatisticsResponse managePropertygraphStatistics(ManagePropertygraphStatisticsRequest managePropertygraphStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ManagePropertygraphStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, managePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ManagePropertygraphStatistics");
            ManagePropertygraphStatisticsResponse managePropertygraphStatisticsResponse = (ManagePropertygraphStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ManagePropertygraphStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)managePropertygraphStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ManagePropertygraphStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return managePropertygraphStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$managePropertygraphStatistics$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManageSparqlStatisticsResponse manageSparqlStatistics(ManageSparqlStatisticsRequest manageSparqlStatisticsRequest) throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ManageSparqlStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, manageSparqlStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ManageSparqlStatistics");
            ManageSparqlStatisticsResponse manageSparqlStatisticsResponse = (ManageSparqlStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ManageSparqlStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)manageSparqlStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ManageSparqlStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return manageSparqlStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$manageSparqlStatistics$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLoaderJobResponse startLoaderJob(StartLoaderJobRequest startLoaderJobRequest) throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException, S3Exception, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLoaderJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, startLoaderJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLoaderJob");
            StartLoaderJobResponse startLoaderJobResponse = (StartLoaderJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLoaderJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startLoaderJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLoaderJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLoaderJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$startLoaderJob$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMlDataProcessingJobResponse startMLDataProcessingJob(StartMlDataProcessingJobRequest startMlDataProcessingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMlDataProcessingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, startMlDataProcessingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMLDataProcessingJob");
            StartMlDataProcessingJobResponse startMlDataProcessingJobResponse = (StartMlDataProcessingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMLDataProcessingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMlDataProcessingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMlDataProcessingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMlDataProcessingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$startMLDataProcessingJob$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMlModelTrainingJobResponse startMLModelTrainingJob(StartMlModelTrainingJobRequest startMlModelTrainingJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMlModelTrainingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, startMlModelTrainingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMLModelTrainingJob");
            StartMlModelTrainingJobResponse startMlModelTrainingJobResponse = (StartMlModelTrainingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMLModelTrainingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMlModelTrainingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMlModelTrainingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMlModelTrainingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$startMLModelTrainingJob$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMlModelTransformJobResponse startMLModelTransformJob(StartMlModelTransformJobRequest startMlModelTransformJobRequest) throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMlModelTransformJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNeptunedataClient.resolveMetricPublishers(this.clientConfiguration, startMlModelTransformJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMLModelTransformJob");
            StartMlModelTransformJobResponse startMlModelTransformJobResponse = (StartMlModelTransformJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMLModelTransformJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMlModelTransformJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMlModelTransformJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMlModelTransformJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptunedataClient.lambda$startMLModelTransformJob$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "neptune-db";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NeptunedataException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").customErrorCodeFieldName("code").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StreamRecordsNotFoundException").exceptionBuilderSupplier(StreamRecordsNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BulkLoadIdNotFoundException").exceptionBuilderSupplier(BulkLoadIdNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNumericDataException").exceptionBuilderSupplier(InvalidNumericDataException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalArgumentException").exceptionBuilderSupplier(IllegalArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadUrlAccessDeniedException").exceptionBuilderSupplier(LoadUrlAccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingParameterException").exceptionBuilderSupplier(MissingParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CancelledByUserException").exceptionBuilderSupplier(CancelledByUserException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryLimitExceededException").exceptionBuilderSupplier(QueryLimitExceededException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MemoryLimitExceededException").exceptionBuilderSupplier(MemoryLimitExceededException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParsingException").exceptionBuilderSupplier(ParsingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryTooLargeException").exceptionBuilderSupplier(QueryTooLargeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(Integer.valueOf(405)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3Exception").exceptionBuilderSupplier(S3Exception::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReadOnlyViolationException").exceptionBuilderSupplier(ReadOnlyViolationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StatisticsNotAvailableException").exceptionBuilderSupplier(StatisticsNotAvailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MLResourceNotFoundException").exceptionBuilderSupplier(MlResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConstraintViolationException").exceptionBuilderSupplier(ConstraintViolationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedQueryException").exceptionBuilderSupplier(MalformedQueryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientTimeoutException").exceptionBuilderSupplier(ClientTimeoutException::builder).httpStatusCode(Integer.valueOf(408)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionsFailedException").exceptionBuilderSupplier(PreconditionsFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredStreamException").exceptionBuilderSupplier(ExpiredStreamException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryLimitException").exceptionBuilderSupplier(QueryLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerShutdownException").exceptionBuilderSupplier(ServerShutdownException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FailureByQueryException").exceptionBuilderSupplier(FailureByQueryException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TimeLimitExceededException").exceptionBuilderSupplier(TimeLimitExceededException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final NeptunedataServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$startMLModelTransformJob$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMLModelTrainingJob$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMLDataProcessingJob$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLoaderJob$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$manageSparqlStatistics$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$managePropertygraphStatistics$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOpenCypherQueries$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMLModelTransformJobs$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMLModelTrainingJobs$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMLEndpoints$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMLDataProcessingJobs$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLoaderJobs$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGremlinQueries$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSparqlStream$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSparqlStatistics$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRDFGraphSummary$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPropertygraphSummary$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPropertygraphStream$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPropertygraphStatistics$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenCypherQueryStatus$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLModelTransformJob$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLModelTrainingJob$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLEndpoint$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLDataProcessingJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoaderJobStatus$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGremlinQueryStatus$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEngineStatus$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeOpenCypherQuery$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeOpenCypherExplainQuery$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeGremlinQuery$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeGremlinProfileQuery$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeGremlinExplainQuery$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeFastReset$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSparqlStatistics$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePropertygraphStatistics$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMLEndpoint$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMLEndpoint$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelOpenCypherQuery$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelMLModelTransformJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelMLModelTrainingJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelMLDataProcessingJob$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelLoaderJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelGremlinQuery$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

