/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptunedata.DefaultNeptunedataBaseClientBuilder;
import software.amazon.awssdk.services.neptunedata.DefaultNeptunedataClient;
import software.amazon.awssdk.services.neptunedata.NeptunedataClient;
import software.amazon.awssdk.services.neptunedata.NeptunedataClientBuilder;
import software.amazon.awssdk.services.neptunedata.NeptunedataServiceClientConfiguration;
import software.amazon.awssdk.services.neptunedata.endpoints.NeptunedataEndpointProvider;

@SdkInternalApi
final class DefaultNeptunedataClientBuilder
extends DefaultNeptunedataBaseClientBuilder<NeptunedataClientBuilder, NeptunedataClient>
implements NeptunedataClientBuilder {
    DefaultNeptunedataClientBuilder() {
    }

    @Override
    public DefaultNeptunedataClientBuilder endpointProvider(NeptunedataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NeptunedataClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultNeptunedataClientBuilder.validateClientOptions(clientConfiguration);
        NeptunedataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNeptunedataClient client = new DefaultNeptunedataClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NeptunedataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NeptunedataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

